/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.component.dataset.DataSet;
import org.apache.camel.component.dataset.DataSetConsumer;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSetEndpoint
extends MockEndpoint
implements Service {
    private static final transient Log LOG = LogFactory.getLog(DataSetEndpoint.class);
    private DataSet dataSet;
    private AtomicInteger receivedCounter = new AtomicInteger();
    private long produceDelay;
    private long consumeDelay;
    private long startTime;
    private long preloadSize;

    public DataSetEndpoint() {
    }

    public DataSetEndpoint(String endpointUri, Component component, DataSet dataSet) {
        super(endpointUri, component);
        this.dataSet = dataSet;
    }

    public DataSetEndpoint(String endpointUri, DataSet dataSet) {
        super(endpointUri);
        this.dataSet = dataSet;
    }

    public static void assertEquals(String description, Object expected, Object actual, Exchange exchange) {
        if (!ObjectHelper.equal(expected, actual)) {
            throw new AssertionError((Object)(description + " does not match. Expected: " + expected + " but was: " + actual + " on " + exchange + " with headers: " + exchange.getIn().getHeaders()));
        }
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new DataSetConsumer(this, processor);
    }

    public void reset() {
        super.reset();
        this.receivedCounter.set(0);
    }

    public int getReceivedCounter() {
        return this.receivedCounter.get();
    }

    public Exchange createExchange(long messageIndex) throws Exception {
        Exchange exchange = this.createExchange();
        this.getDataSet().populateMessage(exchange, messageIndex);
        Message in = exchange.getIn();
        in.setHeader("CamelDataSetIndex", messageIndex);
        return exchange;
    }

    protected void waitForCompleteLatch() throws InterruptedException {
        long size = this.getDataSet().getSize();
        this.setResultWaitTime(size *= 4000L);
        super.waitForCompleteLatch();
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public long getPreloadSize() {
        return this.preloadSize;
    }

    public void setPreloadSize(long preloadSize) {
        this.preloadSize = preloadSize;
    }

    public long getConsumeDelay() {
        return this.consumeDelay;
    }

    public void setConsumeDelay(long consumeDelay) {
        this.consumeDelay = consumeDelay;
    }

    public long getProduceDelay() {
        return this.produceDelay;
    }

    public void setProduceDelay(long produceDelay) {
        this.produceDelay = produceDelay;
    }

    protected void performAssertions(Exchange actual) throws Exception {
        long group;
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        int receivedCount = this.receivedCounter.incrementAndGet();
        long index = receivedCount - 1;
        Exchange expected = this.createExchange(index);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Received message: " + index + " = " + actual));
        }
        this.assertMessageExpected(index, expected, actual);
        if (this.consumeDelay > 0L) {
            Thread.sleep(this.consumeDelay);
        }
        if ((long)receivedCount % (group = this.getDataSet().getReportCount()) == 0L) {
            this.reportProgress(actual, receivedCount);
        }
    }

    protected void reportProgress(Exchange actual, int receivedCount) {
        long time = System.currentTimeMillis();
        long elapsed = time - this.startTime;
        this.startTime = time;
        LOG.info((Object)("Received: " + receivedCount + " messages so far. Last group took: " + elapsed + " millis"));
    }

    protected void assertMessageExpected(long index, Exchange expected, Exchange actual) throws Exception {
        long actualCounter = ExchangeHelper.getMandatoryHeader(actual, "CamelDataSetIndex", Long.class);
        DataSetEndpoint.assertEquals("Header: CamelDataSetIndex", index, actualCounter, actual);
        this.getDataSet().assertMessageExpected(this, expected, actual, index);
    }

    public void start() throws Exception {
        long size = this.getDataSet().getSize();
        this.expectedMessageCount((int)size);
    }

    public void stop() throws Exception {
    }
}

