/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.component.seda.CollectionProducer;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.SynchronizationAdapter;
import org.apache.camel.util.ExchangeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SedaProducer
extends CollectionProducer {
    private final SedaEndpoint endpoint;
    private final WaitForTaskToComplete waitForTaskToComplete;
    private final long timeout;

    public SedaProducer(SedaEndpoint endpoint, BlockingQueue<Exchange> queue, WaitForTaskToComplete waitForTaskToComplete, long timeout) {
        super(endpoint, queue);
        this.endpoint = endpoint;
        this.waitForTaskToComplete = waitForTaskToComplete;
        this.timeout = timeout;
    }

    @Override
    public void process(final Exchange exchange) throws Exception {
        Exchange copy = exchange.copy(true);
        copy.setFromEndpoint(this.endpoint);
        WaitForTaskToComplete wait = this.waitForTaskToComplete;
        if (exchange.getProperty("CamelAsyncWait") != null) {
            wait = exchange.getProperty("CamelAsyncWait", WaitForTaskToComplete.class);
        }
        if (wait == WaitForTaskToComplete.Always || wait == WaitForTaskToComplete.IfReplyExpected && ExchangeHelper.isOutCapable(exchange)) {
            final CountDownLatch latch = new CountDownLatch(1);
            copy.addOnCompletion(new SynchronizationAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onDone(Exchange response) {
                    try {
                        ExchangeHelper.copyResults(exchange, response);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            this.queue.add(copy);
            boolean done = latch.await(this.timeout, TimeUnit.MILLISECONDS);
            if (!done) {
                exchange.setException(new ExchangeTimedOutException(exchange, this.timeout));
            }
        } else {
            this.queue.add(copy);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.endpoint.onStarted(this);
    }

    @Override
    protected void doStop() throws Exception {
        this.endpoint.onStopped(this);
        super.doStop();
    }
}

