/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.management.CamelNamingStrategy;
import org.apache.camel.management.DefaultInstrumentationAgent;
import org.apache.camel.management.InstrumentationInterceptStrategy;
import org.apache.camel.management.InstrumentationProcessor;
import org.apache.camel.management.ManagedEndpoint;
import org.apache.camel.management.ManagedRoute;
import org.apache.camel.management.ManagedService;
import org.apache.camel.management.PerformanceCounter;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.InstrumentationAgent;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationLifecycleStrategy
implements LifecycleStrategy {
    private static final transient Log LOG = LogFactory.getLog(InstrumentationProcessor.class);
    private static final String MANAGED_RESOURCE_CLASSNAME = "org.springframework.jmx.export.annotation.ManagedResource";
    private InstrumentationAgent agent;
    private CamelNamingStrategy namingStrategy;
    private boolean initialized;
    private final Map<Endpoint, InstrumentationProcessor> registeredRoutes = new HashMap<Endpoint, InstrumentationProcessor>();

    public InstrumentationLifecycleStrategy() {
        this(new DefaultInstrumentationAgent());
    }

    public InstrumentationLifecycleStrategy(InstrumentationAgent agent) {
        this.agent = agent;
    }

    public InstrumentationLifecycleStrategy(InstrumentationAgent agent, CamelContext context) {
        this.agent = agent;
        this.onContextStart(context);
    }

    @Override
    public void onContextStart(CamelContext context) {
        if (context instanceof DefaultCamelContext) {
            try {
                this.initialized = true;
                DefaultCamelContext dc = (DefaultCamelContext)context;
                dc.addService(this.agent);
                this.namingStrategy = new CamelNamingStrategy(this.agent.getMBeanObjectDomainName());
                ManagedService ms = new ManagedService(dc);
                this.agent.register(ms, this.getNamingStrategy().getObjectName(dc));
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
    }

    @Override
    public void onEndpointAdd(Endpoint endpoint) {
        if (!this.initialized) {
            return;
        }
        Class annotationClass = this.resolveManagedAnnotation(endpoint);
        if (annotationClass == null) {
            this.registerEndpointAsManagedEndpoint(endpoint);
            return;
        }
        Object annotation = endpoint.getClass().getAnnotation(annotationClass);
        if (annotation == null) {
            this.registerEndpointAsManagedEndpoint(endpoint);
        } else {
            this.attemptToRegisterManagedResource(endpoint, annotation);
        }
    }

    private Class resolveManagedAnnotation(Endpoint endpoint) {
        CamelContext context = endpoint.getCamelContext();
        ClassResolver resolver = context.getClassResolver();
        return resolver.resolveClass(MANAGED_RESOURCE_CLASSNAME);
    }

    private void attemptToRegisterManagedResource(Endpoint endpoint, Object annotation) {
        try {
            Method m = annotation.getClass().getMethod("objectName", new Class[0]);
            String objectNameStr = (String)m.invoke(annotation, new Object[0]);
            ObjectName objectName = new ObjectName(objectNameStr);
            this.agent.register(endpoint, objectName);
        }
        catch (Exception e) {
            LOG.debug((Object)"objectName method not present, wrapping endpoint in ManagedEndpoint instead");
            this.registerEndpointAsManagedEndpoint(endpoint);
        }
    }

    private void registerEndpointAsManagedEndpoint(Endpoint endpoint) {
        try {
            ManagedEndpoint me = new ManagedEndpoint(endpoint);
            this.agent.register(me, this.getNamingStrategy().getObjectName(me));
        }
        catch (JMException e) {
            LOG.warn((Object)("Could not register Endpoint MBean for uri: " + endpoint.getEndpointUri()), (Throwable)e);
        }
    }

    @Override
    public void onRoutesAdd(Collection<Route> routes) {
        if (!this.initialized) {
            return;
        }
        for (Route route : routes) {
            try {
                ManagedRoute mr = new ManagedRoute(route);
                InstrumentationProcessor processor = this.registeredRoutes.get(route.getEndpoint());
                if (processor == null) {
                    LOG.warn((Object)("Route has not been instrumented for endpoint: " + route.getEndpoint()));
                } else {
                    processor.setCounter(mr);
                }
                this.agent.register(mr, this.getNamingStrategy().getObjectName(mr));
            }
            catch (JMException e) {
                LOG.warn((Object)"Could not register Route MBean", (Throwable)e);
            }
        }
    }

    @Override
    public void onServiceAdd(CamelContext context, Service service) {
        if (!this.initialized) {
            return;
        }
        if (service instanceof ServiceSupport && service instanceof Consumer) {
            try {
                ManagedService ms = new ManagedService((ServiceSupport)service);
                this.agent.register(ms, this.getNamingStrategy().getObjectName(context, ms));
            }
            catch (JMException e) {
                LOG.warn((Object)"Could not register Service MBean", (Throwable)e);
            }
        }
    }

    @Override
    public void onRouteContextCreate(RouteContext routeContext) {
        if (!this.initialized) {
            return;
        }
        HashMap<ProcessorDefinition, PerformanceCounter> registeredCounters = new HashMap<ProcessorDefinition, PerformanceCounter>();
        RouteDefinition route = routeContext.getRoute();
        for (ProcessorDefinition processor : route.getOutputs()) {
            if (!this.registerProcessor(processor)) continue;
            ObjectName name = null;
            try {
                name = this.getNamingStrategy().getObjectName(routeContext, processor);
                PerformanceCounter pc = new PerformanceCounter();
                this.agent.register(pc, name);
                registeredCounters.put(processor, pc);
            }
            catch (MalformedObjectNameException e) {
                LOG.warn((Object)("Could not create MBean name: " + name), (Throwable)e);
            }
            catch (JMException e) {
                LOG.warn((Object)("Could not register PerformanceCounter MBean: " + name), (Throwable)e);
            }
        }
        routeContext.addInterceptStrategy(new InstrumentationInterceptStrategy(registeredCounters));
        final Endpoint endpoint = routeContext.getEndpoint();
        ProcessorDefinition out = routeContext.getRoute().getOutputs().get(0);
        out.addInterceptStrategy(new InterceptStrategy(){

            public Processor wrapProcessorInInterceptors(ProcessorDefinition processorDefinition, Processor target, Processor nextTarget) throws Exception {
                if (InstrumentationLifecycleStrategy.this.registeredRoutes.containsKey(endpoint)) {
                    return target;
                }
                InstrumentationProcessor wrapper = new InstrumentationProcessor(null);
                wrapper.setType(processorDefinition.getShortName());
                wrapper.setProcessor(target);
                InstrumentationLifecycleStrategy.this.registeredRoutes.put(endpoint, wrapper);
                return wrapper;
            }

            public String toString() {
                return "Instrument";
            }
        });
    }

    protected boolean registerProcessor(ProcessorDefinition processor) {
        DefaultInstrumentationAgent dia;
        if (this.agent instanceof DefaultInstrumentationAgent && (dia = (DefaultInstrumentationAgent)this.agent).getOnlyRegisterProcessorWithCustomId() != null && dia.getOnlyRegisterProcessorWithCustomId().booleanValue()) {
            return processor.hasCustomIdAssigned();
        }
        return true;
    }

    public CamelNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(CamelNamingStrategy strategy) {
        this.namingStrategy = strategy;
    }

    public void setAgent(InstrumentationAgent agent) {
        this.agent = agent;
    }
}

