/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.Traceable;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.concurrent.AtomicExchange;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;
import org.apache.camel.util.concurrent.SubmitOrderedCompletionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastProcessor
extends ServiceSupport
implements Processor,
Navigate,
Traceable {
    private static final transient Log LOG = LogFactory.getLog(MulticastProcessor.class);
    private final Collection<Processor> processors;
    private final AggregationStrategy aggregationStrategy;
    private final boolean isParallelProcessing;
    private final boolean streaming;
    private ExecutorService executorService;

    public MulticastProcessor(Collection<Processor> processors) {
        this(processors, null);
    }

    public MulticastProcessor(Collection<Processor> processors, AggregationStrategy aggregationStrategy) {
        this(processors, aggregationStrategy, false, null, false);
    }

    public MulticastProcessor(Collection<Processor> processors, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean streaming) {
        ObjectHelper.notNull(processors, "processors");
        this.processors = processors;
        this.aggregationStrategy = aggregationStrategy;
        this.isParallelProcessing = parallelProcessing;
        this.executorService = executorService;
        this.streaming = streaming;
        if (this.isParallelProcessing() && this.executorService == null) {
            this.executorService = ExecutorServiceHelper.newScheduledThreadPool(5, "Multicast", true);
        }
    }

    public String toString() {
        return "Multicast[" + this.getProcessors() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "Multicast";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AtomicExchange result = new AtomicExchange();
        Iterable<ProcessorExchangePair> pairs = this.createProcessorExchangePairs(exchange);
        if (this.isParallelProcessing()) {
            this.doProcessParallel(result, pairs, this.isStreaming());
        } else {
            this.doProcessSequntiel(result, pairs);
        }
        if (result.get() != null) {
            ExchangeHelper.copyResults(exchange, (Exchange)result.get());
        }
    }

    protected void doProcessParallel(AtomicExchange result, Iterable<ProcessorExchangePair> pairs, boolean streaming) throws InterruptedException, ExecutionException {
        CompletionService completion = streaming ? new ExecutorCompletionService(this.executorService) : new SubmitOrderedCompletionService(this.executorService);
        int total = 0;
        for (ProcessorExchangePair pair : pairs) {
            final Processor producer = pair.getProcessor();
            final Exchange subExchange = pair.getExchange();
            this.updateNewExchange(subExchange, total, pairs);
            completion.submit(new Callable<Exchange>(){

                @Override
                public Exchange call() throws Exception {
                    try {
                        producer.process(subExchange);
                    }
                    catch (Exception e) {
                        subExchange.setException(e);
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Parallel processing complete for exchange: " + subExchange));
                    }
                    return subExchange;
                }
            });
            ++total;
        }
        for (int i = 0; i < total; ++i) {
            Future future = completion.take();
            Exchange subExchange = (Exchange)future.get();
            if (this.aggregationStrategy == null) continue;
            this.doAggregate(result, subExchange);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Done parallel processing " + total + " exchanges"));
        }
    }

    protected void doProcessSequntiel(AtomicExchange result, Iterable<ProcessorExchangePair> pairs) throws Exception {
        int total = 0;
        for (ProcessorExchangePair pair : pairs) {
            Processor producer = pair.getProcessor();
            Exchange subExchange = pair.getExchange();
            this.updateNewExchange(subExchange, total, pairs);
            producer.process(subExchange);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Sequientel processing complete for number " + total + " exchange: " + subExchange));
            }
            if (this.aggregationStrategy != null) {
                this.doAggregate(result, subExchange);
            }
            ++total;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Done sequientel processing " + total + " exchanges"));
        }
    }

    protected synchronized void doAggregate(AtomicExchange result, Exchange exchange) {
        Boolean filtered = exchange.getProperty("CamelFiltered", Boolean.class);
        if (!(this.aggregationStrategy == null || filtered != null && filtered.booleanValue())) {
            Exchange oldExchange = (Exchange)result.get();
            ExchangeHelper.prepareAggregation(oldExchange, exchange);
            result.set(this.aggregationStrategy.aggregate(oldExchange, exchange));
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Cannot aggregate exchange as its filtered: " + exchange));
        }
    }

    protected void updateNewExchange(Exchange exchange, int index, Iterable<ProcessorExchangePair> allPairs) {
        exchange.setProperty("CamelMulticastIndex", index);
    }

    protected Iterable<ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) {
        ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>(this.processors.size());
        for (Processor processor : this.processors) {
            Exchange copy = exchange.copy();
            result.add(new ProcessorExchangePair(processor, copy));
        }
        return result;
    }

    @Override
    protected void doStop() throws Exception {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService.awaitTermination(0L, TimeUnit.SECONDS);
        }
        ServiceHelper.stopServices(this.processors);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.processors);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public Collection<Processor> getProcessors() {
        return this.processors;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public boolean isParallelProcessing() {
        return this.isParallelProcessing;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        return new ArrayList<Processor>(this.processors);
    }

    @Override
    public boolean hasNext() {
        return this.processors != null && !this.processors.isEmpty();
    }

    static class ProcessorExchangePair {
        private final Processor processor;
        private final Exchange exchange;

        public ProcessorExchangePair(Processor processor, Exchange exchange) {
            this.processor = processor;
            this.exchange = exchange;
        }

        public Processor getProcessor() {
            return this.processor;
        }

        public Exchange getExchange() {
            return this.exchange;
        }
    }
}

