/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.CatchProcessor;
import org.apache.camel.processor.Traceable;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TryProcessor
extends ServiceSupport
implements Processor,
Navigate<Processor>,
Traceable {
    private static final transient Log LOG = LogFactory.getLog(TryProcessor.class);
    protected final Processor tryProcessor;
    protected final List<CatchProcessor> catchClauses;
    protected final Processor finallyProcessor;

    public TryProcessor(Processor tryProcessor, List<CatchProcessor> catchClauses, Processor finallyProcessor) {
        this.tryProcessor = tryProcessor;
        this.catchClauses = catchClauses;
        this.finallyProcessor = finallyProcessor;
    }

    public String toString() {
        String finallyText = this.finallyProcessor == null ? "" : " Finally {" + this.finallyProcessor + "}";
        return "Try {" + this.tryProcessor + "} " + (this.catchClauses != null ? this.catchClauses : "") + finallyText;
    }

    @Override
    public String getTraceLabel() {
        return "Try";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Exchange exchange) throws Exception {
        Exception e;
        try {
            this.tryProcessor.process(exchange);
            e = exchange.getException();
            if (e != null && ExchangeHelper.isFailureHandled(exchange)) {
                e = null;
            }
        }
        catch (Exception ex) {
            e = ex;
            exchange.setException(e);
        }
        try {
            if (e != null) {
                this.handleException(exchange, e);
            }
        }
        finally {
            this.processFinally(exchange);
        }
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.tryProcessor, this.catchClauses, this.finallyProcessor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.finallyProcessor, this.catchClauses, this.tryProcessor);
    }

    protected void handleException(Exchange exchange, Throwable e) throws Exception {
        if (this.catchClauses == null) {
            return;
        }
        for (CatchProcessor catchClause : this.catchClauses) {
            if (!catchClause.catches(exchange, e)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("This TryProcessor catches the exception: " + e.getClass().getName() + " caused by: " + e.getMessage()));
            }
            Exchange localExchange = exchange.copy();
            localExchange.setProperty("CamelExceptionCaught", e);
            localExchange.setException(null);
            catchClause.process(localExchange);
            boolean handled = catchClause.handles(exchange);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The exception is handled: " + handled + " for the exception: " + e.getClass().getName() + " caused by: " + e.getMessage()));
            }
            if (handled) {
                localExchange.removeProperty("CamelExceptionCaught");
            } else if (localExchange.getException() == null) {
                localExchange.setException(localExchange.getProperty("CamelExceptionCaught", Exception.class));
            }
            ExchangeHelper.copyResults(exchange, localExchange);
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("This TryProcessor does not catch the exception: " + e.getClass().getName() + " caused by: " + e.getMessage()));
        }
    }

    protected void processFinally(Exchange exchange) throws Exception {
        if (this.finallyProcessor != null) {
            Exception lastException = exchange.getException();
            exchange.setException(null);
            this.finallyProcessor.process(exchange);
            if (exchange.getException() == null) {
                exchange.setException(lastException);
            }
        }
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>();
        if (this.tryProcessor != null) {
            answer.add(this.tryProcessor);
        }
        if (this.catchClauses != null) {
            answer.addAll(this.catchClauses);
        }
        if (this.finallyProcessor != null) {
            answer.add(this.finallyProcessor);
        }
        return answer;
    }

    @Override
    public boolean hasNext() {
        return this.tryProcessor != null;
    }
}

