/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.io.Serializable;
import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RouteNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.interceptor.TraceEventMessage;
import org.apache.camel.spi.TraceableUnitOfWork;
import org.apache.camel.util.MessageHelper;

public final class DefaultTraceEventMessage
implements Serializable,
TraceEventMessage {
    private Date timestamp;
    private String fromEndpointUri;
    private String previousNode;
    private String toNode;
    private String exchangeId;
    private String shortExchangeId;
    private String exchangePattern;
    private String properties;
    private String headers;
    private String body;
    private String bodyType;
    private String outHeaders;
    private String outBody;
    private String outBodyType;
    private String causedByException;

    public DefaultTraceEventMessage(Date timestamp, ProcessorDefinition toNode, Exchange exchange) {
        Message in = exchange.getIn();
        this.timestamp = timestamp;
        this.fromEndpointUri = exchange.getFromEndpoint() != null ? exchange.getFromEndpoint().getEndpointUri() : null;
        this.previousNode = DefaultTraceEventMessage.extractFromNode(exchange);
        this.toNode = DefaultTraceEventMessage.extractToNode(exchange);
        this.exchangeId = exchange.getExchangeId();
        this.shortExchangeId = DefaultTraceEventMessage.extractShortExchangeId(exchange);
        this.exchangePattern = exchange.getPattern().toString();
        this.properties = exchange.getProperties().isEmpty() ? null : exchange.getProperties().toString();
        this.headers = in.getHeaders().isEmpty() ? null : in.getHeaders().toString();
        this.body = MessageHelper.extractBodyAsString(in);
        this.bodyType = MessageHelper.getBodyTypeName(in);
        if (exchange.hasOut()) {
            Message out = exchange.getOut();
            this.outHeaders = out.getHeaders().isEmpty() ? null : out.getHeaders().toString();
            this.outBody = MessageHelper.extractBodyAsString(out);
            this.outBodyType = MessageHelper.getBodyTypeName(out);
        }
        this.causedByException = exchange.getException() != null ? exchange.getException().toString() : null;
    }

    private static String extractShortExchangeId(Exchange exchange) {
        return exchange.getExchangeId().substring(exchange.getExchangeId().indexOf("/") + 1);
    }

    private static String extractFromNode(Exchange exchange) {
        if (exchange.getUnitOfWork() instanceof TraceableUnitOfWork) {
            TraceableUnitOfWork tuow = (TraceableUnitOfWork)exchange.getUnitOfWork();
            RouteNode last = tuow.getSecondLastNode();
            return last != null ? last.getLabel(exchange) : null;
        }
        return null;
    }

    private static String extractToNode(Exchange exchange) {
        if (exchange.getUnitOfWork() instanceof TraceableUnitOfWork) {
            TraceableUnitOfWork tuow = (TraceableUnitOfWork)exchange.getUnitOfWork();
            RouteNode last = tuow.getLastNode();
            return last != null ? last.getLabel(exchange) : null;
        }
        return null;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getFromEndpointUri() {
        return this.fromEndpointUri;
    }

    public String getPreviousNode() {
        return this.previousNode;
    }

    public String getToNode() {
        return this.toNode;
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public String getShortExchangeId() {
        return this.shortExchangeId;
    }

    public String getExchangePattern() {
        return this.exchangePattern;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public String getBodyType() {
        return this.bodyType;
    }

    public String getOutBody() {
        return this.outBody;
    }

    public String getOutBodyType() {
        return this.outBodyType;
    }

    public String getOutHeaders() {
        return this.outHeaders;
    }

    public void setOutHeaders(String outHeaders) {
        this.outHeaders = outHeaders;
    }

    public String getCausedByException() {
        return this.causedByException;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void setFromEndpointUri(String fromEndpointUri) {
        this.fromEndpointUri = fromEndpointUri;
    }

    public void setPreviousNode(String previousNode) {
        this.previousNode = previousNode;
    }

    public void setToNode(String toNode) {
        this.toNode = toNode;
    }

    public void setExchangeId(String exchangeId) {
        this.exchangeId = exchangeId;
    }

    public void setShortExchangeId(String shortExchangeId) {
        this.shortExchangeId = shortExchangeId;
    }

    public void setExchangePattern(String exchangePattern) {
        this.exchangePattern = exchangePattern;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setBodyType(String bodyType) {
        this.bodyType = bodyType;
    }

    public void setOutBody(String outBody) {
        this.outBody = outBody;
    }

    public void setOutBodyType(String outBodyType) {
        this.outBodyType = outBodyType;
    }

    public void setCausedByException(String causedByException) {
        this.causedByException = causedByException;
    }

    public String toString() {
        return "TraceEventMessage[" + this.exchangeId + "] on node: " + this.toNode;
    }
}

