/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.Date;
import java.util.HashMap;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultRouteNode;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.interceptor.DefaultTraceEventMessage;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.TraceableUnitOfWork;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TraceInterceptor
extends DelegateProcessor
implements ExchangeFormatter {
    private static final transient Log LOG = LogFactory.getLog(TraceInterceptor.class);
    private static final String JPA_TRACE_EVENT_MESSAGE = "org.apache.camel.processor.interceptor.JpaTraceEventMessage";
    private Logger logger;
    private Producer traceEventProducer;
    private final ProcessorDefinition node;
    private final Tracer tracer;
    private TraceFormatter formatter;
    private Class jpaTraceEventMessageClass;

    public TraceInterceptor(ProcessorDefinition node, Processor target, TraceFormatter formatter, Tracer tracer) {
        super(target);
        this.tracer = tracer;
        this.node = node;
        this.formatter = formatter;
        this.logger = tracer.getLogName() != null ? new Logger(LogFactory.getLog((String)tracer.getLogName()), this) : new Logger(LogFactory.getLog(TraceInterceptor.class), this);
        if (tracer.getLogLevel() != null) {
            this.logger.setLevel(tracer.getLogLevel());
        }
        if (tracer.getFormatter() != null) {
            this.formatter = tracer.getFormatter();
        }
    }

    public TraceInterceptor(ProcessorDefinition node, Processor target, Tracer tracer) {
        this(node, target, null, tracer);
    }

    public String toString() {
        return "TraceInterceptor[" + this.node + "]";
    }

    public void process(Exchange exchange) throws Exception {
        if (exchange.getProperty("CamelTraceEvent", Boolean.class) != null) {
            super.process(exchange);
            return;
        }
        boolean shouldLog = this.shouldLogNode(this.node) && this.shouldLogExchange(exchange);
        boolean trace = true;
        try {
            TraceableUnitOfWork tuow;
            if (shouldLog && exchange.getUnitOfWork() instanceof TraceableUnitOfWork) {
                tuow = (TraceableUnitOfWork)exchange.getUnitOfWork();
                if (this.node instanceof OnExceptionDefinition) {
                    trace = this.beforeOnException((OnExceptionDefinition)this.node, tuow, exchange);
                } else if (this.node instanceof OnCompletionDefinition) {
                    trace = this.beforeOnCompletion((OnCompletionDefinition)this.node, tuow, exchange);
                } else {
                    tuow.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
                }
            }
            if (trace) {
                this.logExchange(exchange);
                this.traceExchange(exchange);
            }
            if (exchange.getUnitOfWork() instanceof TraceableUnitOfWork) {
                tuow = (TraceableUnitOfWork)exchange.getUnitOfWork();
                if (this.node instanceof InterceptDefinition) {
                    this.afterIntercept((InterceptDefinition)this.node, tuow, exchange);
                }
            }
            super.proceed(exchange);
            if (shouldLog && this.tracer.isTraceOutExchanges()) {
                this.logExchange(exchange);
                this.traceExchange(exchange);
            }
        }
        catch (Exception e) {
            if (this.shouldLogException(exchange)) {
                this.logException(exchange, e);
            }
            throw e;
        }
    }

    public Object format(Exchange exchange) {
        return this.formatter.format(this, this.getNode(), exchange);
    }

    public ProcessorDefinition getNode() {
        return this.node;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public TraceFormatter getFormatter() {
        return this.formatter;
    }

    protected boolean beforeOnException(OnExceptionDefinition onException, TraceableUnitOfWork tuow, Exchange exchange) throws Exception {
        int index = tuow.getAndIncrement(this.node);
        if (index == 0) {
            class OnExceptionExpression
            implements Expression {
                OnExceptionExpression() {
                }

                public Object evaluate(Exchange exchange, Class type) {
                    String label = "OnException";
                    if (exchange.getProperty("CamelExceptionCaught") != null) {
                        label = label + "[" + exchange.getProperty("CamelExceptionCaught", Exception.class).getClass().getSimpleName() + "]";
                    }
                    return exchange.getContext().getTypeConverter().convertTo(type, label);
                }
            }
            OnExceptionExpression exp = new OnExceptionExpression();
            tuow.addTraced(new DefaultRouteNode(this.node, exp));
            this.logExchange(exchange);
            this.traceExchange(exchange);
        }
        tuow.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
        return true;
    }

    protected boolean beforeOnCompletion(OnCompletionDefinition onCompletion, TraceableUnitOfWork tuow, Exchange exchange) throws Exception {
        boolean answer;
        boolean bl = answer = tuow.getLastNode() != null;
        if (exchange.getProperty("CamelOnCompletion") != null) {
            int index = tuow.getAndIncrement(this.node);
            if (index == 0) {
                class OnCompletionExpression
                implements Expression {
                    OnCompletionExpression() {
                    }

                    public Object evaluate(Exchange exchange, Class type) {
                        String label = "OnCompletion[" + exchange.getProperty("CamelCorrelationId") + "]";
                        return exchange.getContext().getTypeConverter().convertTo(type, label);
                    }
                }
                OnCompletionExpression exp = new OnCompletionExpression();
                tuow.addTraced(new DefaultRouteNode(this.node, exp));
                tuow.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
                this.logExchange(exchange);
                this.traceExchange(exchange);
            } else {
                tuow.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
            }
        }
        return answer;
    }

    protected boolean afterIntercept(InterceptDefinition interceptr, TraceableUnitOfWork tuow, Exchange exchange) throws Exception {
        InterceptDefinition intercept = (InterceptDefinition)this.node;
        Processor last = intercept.getInterceptedProcessor(tuow.getAndIncrement(intercept));
        if (last != null) {
            tuow.addTraced(new DefaultRouteNode(this.node, last));
            this.logExchange(exchange);
            this.traceExchange(exchange);
        }
        return true;
    }

    protected void logExchange(Exchange exchange) {
        this.logger.process(exchange);
    }

    protected void traceExchange(Exchange exchange) throws Exception {
        if (this.tracer.getDestination() != null || this.tracer.getDestinationUri() != null) {
            Date timestamp = new Date();
            DefaultExchange event = new DefaultExchange(exchange);
            event.setProperty("CamelTraceEventNodeId", this.node.getId());
            event.setProperty("CamelTraceEventTimestamp", timestamp);
            event.setProperty("CamelTraceEventExchange", exchange);
            DefaultTraceEventMessage msg = new DefaultTraceEventMessage(timestamp, this.node, exchange);
            if (this.tracer.isUseJpa()) {
                LOG.trace((Object)"Using class: org.apache.camel.processor.interceptor.JpaTraceEventMessage for tracing event messages");
                this.loadJpaTraceEventMessageClass(exchange);
                Object jpa = ObjectHelper.newInstance(this.jpaTraceEventMessageClass);
                HashMap options = new HashMap();
                IntrospectionSupport.getProperties(msg, options, null);
                IntrospectionSupport.setProperties(jpa, options);
                IntrospectionSupport.setProperty(jpa, "timestamp", msg.getTimestamp());
                event.getIn().setBody(jpa);
            } else {
                event.getIn().setBody(msg);
            }
            event.setProperty("CamelTraceEvent", Boolean.TRUE);
            try {
                this.getTraceEventProducer(exchange).process(event);
            }
            catch (Exception e) {
                LOG.error((Object)("Error processing trace event (original Exchange will continue): " + event), (Throwable)e);
            }
        }
    }

    private synchronized void loadJpaTraceEventMessageClass(Exchange exchange) {
        if (this.jpaTraceEventMessageClass == null) {
            this.jpaTraceEventMessageClass = exchange.getContext().getClassResolver().resolveClass(JPA_TRACE_EVENT_MESSAGE);
            if (this.jpaTraceEventMessageClass == null) {
                throw new IllegalArgumentException("Cannot find class: org.apache.camel.processor.interceptor.JpaTraceEventMessage. Make sure camel-jpa.jar is in the classpath.");
            }
        }
    }

    protected void logException(Exchange exchange, Throwable throwable) {
        if (this.tracer.isTraceExceptions()) {
            if (this.tracer.isLogStackTrace()) {
                this.logger.process(exchange, throwable);
            } else {
                this.logger.process(exchange, ", Exception: " + throwable.toString());
            }
        }
    }

    protected boolean shouldLogExchange(Exchange exchange) {
        return this.tracer.isEnabled() && (this.tracer.getTraceFilter() == null || this.tracer.getTraceFilter().matches(exchange));
    }

    protected boolean shouldLogException(Exchange exchange) {
        return this.tracer.isTraceExceptions();
    }

    public boolean shouldTraceOutExchanges() {
        return this.tracer.isTraceOutExchanges();
    }

    protected boolean shouldLogNode(ProcessorDefinition node) {
        if (node == null) {
            return false;
        }
        return this.tracer.isTraceInterceptors() || !(node instanceof InterceptStrategy);
    }

    private synchronized Producer getTraceEventProducer(Exchange exchange) throws Exception {
        if (this.traceEventProducer == null) {
            Endpoint endpoint = this.tracer.getDestination() != null ? this.tracer.getDestination() : exchange.getContext().getEndpoint(this.tracer.getDestinationUri());
            this.traceEventProducer = endpoint.createProducer();
            ServiceHelper.startService(this.traceEventProducer);
        }
        return this.traceEventProducer;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.traceEventProducer = null;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.traceEventProducer != null) {
            ServiceHelper.stopService(this.traceEventProducer);
        }
    }
}

