/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.loadbalancer.LoadBalancerSupport;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailOverLoadBalancer
extends LoadBalancerSupport {
    private final List<Class> exceptions;

    public FailOverLoadBalancer() {
        this.exceptions = null;
    }

    public FailOverLoadBalancer(List<Class> exceptions) {
        this.exceptions = exceptions;
        for (Class type : exceptions) {
            if (ObjectHelper.isAssignableFrom(Throwable.class, type)) continue;
            throw new IllegalArgumentException("Class is not an instance of Trowable: " + type);
        }
    }

    protected boolean shouldFailOver(Exchange exchange) {
        if (exchange.getException() != null) {
            if (this.exceptions == null || this.exceptions.isEmpty()) {
                return true;
            }
            for (Class exception : this.exceptions) {
                if (exchange.getException(exception) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        List<Processor> list = this.getProcessors();
        if (list.isEmpty()) {
            throw new IllegalStateException("No processors available to process " + exchange);
        }
        int index = 0;
        Processor processor = list.get(index);
        this.processExchange(processor, exchange);
        while (this.shouldFailOver(exchange) && ++index < list.size()) {
            this.prepareExchangeForFailover(exchange);
            processor = list.get(index);
            this.processExchange(processor, exchange);
        }
    }

    protected void prepareExchangeForFailover(Exchange exchange) {
        exchange.setException(null);
        exchange.setProperty("CamelErrorHandlerHandled", null);
        exchange.setProperty("CamelFailureHandled", null);
        exchange.setProperty("CamelExceptionCaught", null);
        exchange.getIn().removeHeader("CamelRedelivered");
        exchange.getIn().removeHeader("CamelRedeliveryCounter");
    }

    private void processExchange(Processor processor, Exchange exchange) {
        if (processor == null) {
            throw new IllegalStateException("No processors could be chosen to process " + exchange);
        }
        try {
            processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
    }

    public String toString() {
        return "FailoverLoadBalancer";
    }
}

