/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.util.ObjectHelper;

public final class MessageHelper {
    private MessageHelper() {
    }

    public static String extractBodyAsString(Message message) {
        Object answer;
        if (message == null) {
            return null;
        }
        StreamCache newBody = message.getBody(StreamCache.class);
        if (newBody != null) {
            message.setBody(newBody);
        }
        if ((answer = message.getBody(String.class)) == null) {
            answer = message.getBody();
        }
        if (newBody != null) {
            newBody.reset();
        }
        return answer != null ? answer.toString() : null;
    }

    public static String getBodyTypeName(Message message) {
        if (message == null) {
            return null;
        }
        String answer = ObjectHelper.classCanonicalName(message.getBody());
        if (answer != null && answer.startsWith("java.lang.")) {
            return answer.substring(10);
        }
        return answer;
    }

    public static void resetStreamCache(Message message) {
        if (message == null) {
            return;
        }
        if (message.getBody() instanceof StreamCache) {
            ((StreamCache)message.getBody()).reset();
        }
    }

    public static String getContentType(Message message) {
        return message.getHeader("Content-Type", String.class);
    }

    public static String getContentEncoding(Message message) {
        return message.getHeader("Content-Encoding", String.class);
    }

    public static String extractBodyForLogging(Message message) {
        Object obj;
        int length = 1000;
        String property = message.getExchange().getContext().getProperties().get("CamelLogDebugBodyMaxChars");
        if (property != null) {
            length = message.getExchange().getContext().getTypeConverter().convertTo(Integer.class, property);
        }
        if ((obj = message.getBody()) == null) {
            return "Message: [Body is null]";
        }
        String body = obj.toString();
        if (body == null) {
            return "Message: [Body is null]";
        }
        if (length > 0 && body.length() > length) {
            body = body.substring(0, length) + "... [Body clipped after " + length + " chars, total length is " + body.length() + "]";
        }
        return "Message: " + body;
    }
}

