/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UuidGenerator {
    private static final transient Log LOG = LogFactory.getLog(UuidGenerator.class);
    private static final String UNIQUE_STUB;
    private static int instanceCount;
    private static String hostName;
    private String seed;
    private long sequence;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UuidGenerator(String prefix) {
        String string = UNIQUE_STUB;
        synchronized (string) {
            this.seed = UuidGenerator.generateSanitizedId(prefix + UNIQUE_STUB + instanceCount++ + "-");
        }
    }

    public UuidGenerator() {
        this("ID-" + hostName);
    }

    public static String getHostName() {
        return hostName;
    }

    public synchronized String generateId() {
        return this.seed + this.sequence++;
    }

    public String generateSanitizedId() {
        return UuidGenerator.generateSanitizedId(this.generateId());
    }

    public static String generateSanitizedId(String id) {
        id = id.replace(':', '-');
        id = id.replace('_', '-');
        id = id.replace('.', '-');
        id = id.replace('/', '-');
        id = id.replace('\\', '-');
        return id;
    }

    static {
        String stub = "";
        boolean canAccessSystemProps = true;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPropertiesAccess();
            }
        }
        catch (SecurityException se) {
            canAccessSystemProps = false;
        }
        if (canAccessSystemProps) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
                ServerSocket ss = new ServerSocket(0);
                stub = "/" + ss.getLocalPort() + "-" + System.currentTimeMillis() + "/";
                Thread.sleep(100L);
                ss.close();
            }
            catch (Exception ioe) {
                LOG.warn((Object)"Could not generate unique stub", (Throwable)ioe);
            }
        } else {
            hostName = "localhost";
            stub = "-1-" + System.currentTimeMillis() + "-";
        }
        UNIQUE_STUB = UuidGenerator.generateSanitizedId(stub);
    }
}

