/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.route.base;

import org.apache.camel.builder.RouteBuilder;
import org.ow2.jonas.camel.service.api.ICamelService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public abstract class CamelRouteBase {
    private Log logger = LogFactory.getLog(this.getClass());
    private ICamelService camelService = null;
    private String camelContextName = null;
    private RouteBuilder routeBuilder;

    public CamelRouteBase(RouteBuilder routeBuilder) {
        this.routeBuilder = routeBuilder;
    }

    public final void start() throws Exception {
        this.camelContextName = this.camelService.startNewContext();
        this.logger.info((Object)"Context started", new Object[0]);
        this.configureCamel(this.camelService, this.camelContextName);
        this.camelService.addRoutes(this.routeBuilder, this.camelContextName);
    }

    protected abstract void configureCamel(ICamelService var1, String var2);

    private void setCamelService(ICamelService service) {
        this.camelService = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsetCamelService(ICamelService service) throws Exception {
        try {
            service.stop(this.camelContextName);
        }
        finally {
            this.camelContextName = null;
            this.camelService = null;
        }
    }
}

