/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.service.itests;

import java.io.File;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.camel.service.api.ICamelService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CamelServiceTestComponent
implements Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private Log logger;
    private boolean __FcamelService;
    private ICamelService camelService;
    private boolean __FcamelContextName;
    private String camelContextName;
    private boolean __FjonasLogs;
    private File jonasLogs;
    private boolean __Mstart;
    private boolean __Mstop;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    ICamelService __getcamelService() {
        if (!this.__FcamelService) {
            return this.camelService;
        }
        return (ICamelService)this.__IM.onGet((Object)this, "camelService");
    }

    void __setcamelService(ICamelService iCamelService) {
        if (!this.__FcamelService) {
            this.camelService = iCamelService;
            return;
        }
        this.__IM.onSet((Object)this, "camelService", (Object)iCamelService);
    }

    String __getcamelContextName() {
        if (!this.__FcamelContextName) {
            return this.camelContextName;
        }
        return (String)this.__IM.onGet((Object)this, "camelContextName");
    }

    void __setcamelContextName(String string) {
        if (!this.__FcamelContextName) {
            this.camelContextName = string;
            return;
        }
        this.__IM.onSet((Object)this, "camelContextName", (Object)string);
    }

    File __getjonasLogs() {
        if (!this.__FjonasLogs) {
            return this.jonasLogs;
        }
        return (File)this.__IM.onGet((Object)this, "jonasLogs");
    }

    void __setjonasLogs(File file) {
        if (!this.__FjonasLogs) {
            this.jonasLogs = file;
            return;
        }
        this.__IM.onSet((Object)this, "jonasLogs", (Object)file);
    }

    public CamelServiceTestComponent() {
        this(null);
    }

    private CamelServiceTestComponent(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(this.getClass()));
        this.__setcamelService(null);
    }

    public void start() throws Throwable {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() throws Throwable {
        String jonasBase = System.getProperty("jonas.base");
        if (jonasBase == null) {
            throw new IllegalStateException("jonas.base is not set!");
        }
        File jonasBaseFile = new File(jonasBase);
        if (!jonasBaseFile.isDirectory()) {
            throw new IllegalStateException(jonasBaseFile + " is not a directory");
        }
        this.__setjonasLogs(new File(jonasBaseFile, "logs"));
        if (!this.__getjonasLogs().isDirectory()) {
            throw new IllegalStateException(this.__getjonasLogs() + " is not a directory");
        }
        final File jonasWorkDir = new File(jonasBaseFile, "work");
        if (!jonasWorkDir.isDirectory()) {
            throw new IllegalStateException(jonasWorkDir + " is not a directory");
        }
        this.__setcamelContextName(this.__getcamelService().startNewContext());
        CamelContext camelContext = this.__getcamelService().getCamelContext(this.__getcamelContextName());
        try {
            this.__getlogger().info((Object)"Camel context {0} started", new Object[]{this.__getcamelContextName()});
            RouteBuilder builder = new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("file://" + jonasWorkDir.getAbsolutePath() + "/inService").process(new Processor(){

                        public void process(Exchange e) throws Exception {
                            String message = (String)e.getIn().getBody(String.class);
                            CamelServiceTestComponent.this.__getlogger().info((Object)"Received File message: {0}", new Object[]{message});
                            File log = new File(CamelServiceTestComponent.this.__getjonasLogs(), message);
                            log.createNewFile();
                        }
                    });
                }
            };
            camelContext.addRoutes((RoutesBuilder)builder);
        }
        catch (Throwable t) {
            this.__getlogger().error((Object)"Cannot start CamelServiceTestComponent", new Object[]{t});
            throw t;
        }
        CamelContext camelContext2 = this.__getcamelService().startAndGetNewContext();
        try {
            this.__getlogger().info((Object)"Camel context {0} started", new Object[]{this.__getcamelContextName()});
            RouteBuilder builder = new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("file://" + jonasWorkDir.getAbsolutePath() + "/inService2").process(new Processor(){

                        public void process(Exchange e) throws Exception {
                            String message = (String)e.getIn().getBody(String.class);
                            CamelServiceTestComponent.this.__getlogger().info((Object)"Received File message: {0}", new Object[]{message});
                            File log = new File(CamelServiceTestComponent.this.__getjonasLogs(), message);
                            log.createNewFile();
                        }
                    });
                }
            };
            camelContext2.addRoutes((RoutesBuilder)builder);
        }
        catch (Throwable t) {
            this.__getlogger().error((Object)"Cannot start CamelServiceTestComponent", new Object[]{t});
            throw t;
        }
    }

    public void stop() throws Exception {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() throws Exception {
        this.__getcamelService().stop(this.__getcamelContextName());
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("camelContextName")) {
                this.__FcamelContextName = true;
            }
            if (set.contains("jonasLogs")) {
                this.__FjonasLogs = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("camelService")) {
                this.__FcamelService = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

