/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.service.itests;

import java.io.File;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CamelContextTestComponent
implements Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private Log logger;
    private boolean __FcamelContext;
    private CamelContext camelContext;
    private boolean __FjonasLogs;
    private File jonasLogs;
    private boolean __Mstart;
    private boolean __Mstop;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    CamelContext __getcamelContext() {
        if (!this.__FcamelContext) {
            return this.camelContext;
        }
        return (CamelContext)this.__IM.onGet((Object)this, "camelContext");
    }

    void __setcamelContext(CamelContext camelContext) {
        if (!this.__FcamelContext) {
            this.camelContext = camelContext;
            return;
        }
        this.__IM.onSet((Object)this, "camelContext", (Object)camelContext);
    }

    File __getjonasLogs() {
        if (!this.__FjonasLogs) {
            return this.jonasLogs;
        }
        return (File)this.__IM.onGet((Object)this, "jonasLogs");
    }

    void __setjonasLogs(File file) {
        if (!this.__FjonasLogs) {
            this.jonasLogs = file;
            return;
        }
        this.__IM.onSet((Object)this, "jonasLogs", (Object)file);
    }

    public CamelContextTestComponent() {
        this(null);
    }

    private CamelContextTestComponent(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(this.getClass()));
        this.__setcamelContext(null);
    }

    public void start() throws Throwable {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() throws Throwable {
        String jonasBase = System.getProperty("jonas.base");
        if (jonasBase == null) {
            throw new IllegalStateException("jonas.base is not set!");
        }
        File jonasBaseFile = new File(jonasBase);
        if (!jonasBaseFile.isDirectory()) {
            throw new IllegalStateException(jonasBaseFile + " is not a directory");
        }
        this.__setjonasLogs(new File(jonasBaseFile, "logs"));
        if (!this.__getjonasLogs().isDirectory()) {
            throw new IllegalStateException(this.__getjonasLogs() + " is not a directory");
        }
        final File jonasWorkDir = new File(jonasBaseFile, "work");
        if (!jonasWorkDir.isDirectory()) {
            throw new IllegalStateException(jonasWorkDir + " is not a directory");
        }
        try {
            this.__getlogger().info((Object)"Camel context {0} started", new Object[]{this.__getcamelContext().getName()});
            RouteBuilder builder = new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("file://" + jonasWorkDir.getAbsolutePath() + "/in").process(new Processor(){

                        public void process(Exchange e) throws Exception {
                            String message = (String)e.getIn().getBody(String.class);
                            CamelContextTestComponent.this.__getlogger().info((Object)"Received File message: {0}", new Object[]{message});
                            File log = new File(CamelContextTestComponent.this.__getjonasLogs(), message);
                            log.createNewFile();
                        }
                    });
                }
            };
            this.__getcamelContext().addRoutes((RoutesBuilder)builder);
        }
        catch (Throwable t) {
            this.__getlogger().error((Object)"Cannot start CamelServiceTestComponent", new Object[]{t});
            throw t;
        }
    }

    public void stop() throws Exception {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() throws Exception {
        this.__getcamelContext().stop();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("jonasLogs")) {
                this.__FjonasLogs = true;
            }
            if (set.contains("camelContext")) {
                this.__FcamelContext = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

