/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.registry.api;

import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractRegistryComponent
implements Component {
    private static Log logger = LogFactory.getLog(AbstractRegistryComponent.class);
    private CamelContext context;

    public CamelContext getCamelContext() {
        return this.context;
    }

    public void setCamelContext(CamelContext context) {
        this.context = context;
    }

    public Endpoint createEndpoint(String name) throws Exception {
        String logicalAddress = name.substring(name.indexOf(58) + 1);
        String technicalAddress = this.lookup(logicalAddress);
        int schemeStart = technicalAddress.indexOf(58);
        String scheme = schemeStart > 0 ? technicalAddress.substring(0, schemeStart) : technicalAddress;
        logger.debug((Object)("AbstractRegistryComponent creating endpoint: name is " + name + ", logicalAddress is " + logicalAddress + ", technicalAddress is " + technicalAddress + ", scheme is " + scheme));
        return this.context.getComponent(scheme).createEndpoint(technicalAddress);
    }

    protected abstract String lookup(String var1) throws Exception;

    public abstract void addValues(InputStream var1) throws Exception;

    public abstract void removeValues(InputStream var1) throws Exception;
}

