/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.samples.camel.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.spi.Registry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGIRegistry
implements Registry {
    private final BundleContext bundleContext;

    public OSGIRegistry(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Object lookup(String name) {
        return this.lookup(name, null);
    }

    public <T> T lookup(String name, Class<T> clazz) {
        return this.lookupByType(clazz).get(name);
    }

    public <T> Map<String, T> lookupByType(Class<T> clazz) {
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(clazz == null ? null : clazz.getName(), null);
            if (refs != null && refs.length >= 0) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                for (ServiceReference ref : refs) {
                    result.put((String)ref.getProperty("name"), this.bundleContext.getService(ref));
                }
                return result;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return Collections.EMPTY_MAP;
    }
}

