/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: OsgiHttpServiceCXFServlet.java 17629 2009-06-12 14:54:41Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.cxf.servlet;

import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.CXFBusFactory;
import org.apache.cxf.bus.extension.ExtensionManager;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;

/**
 * @author Guillaume Porcher
 */
public class OsgiHttpServiceCXFServlet extends CXFNonSpringServlet {

    private static final long serialVersionUID = -8937610402148135912L;

    public OsgiHttpServiceCXFServlet(final String context) {
        final ClassLoader bundleClassLoader = Bus.class.getClassLoader();
        final ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(bundleClassLoader);
        try {
            this.bus = BusFactory.newInstance(CXFBusFactory.class.getName()).createBus();
            this.bus.getExtension(ExtensionManager.class).activateAll();
        } finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        this.servletTransportFactory = new OsgiCxfServletTransportFactory(this.bus, context);
    }
}
