/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: OsgiHttpServiceCXFServlet.java 17729 2009-06-19 14:15:11Z porcherg $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.cxf.servlet;

import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.cxf.Bus;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.servlet.CXFServlet;

/**
 * @author Guillaume Porcher
 */
public class OsgiHttpServiceCXFServlet extends CXFServlet {

    private static final long serialVersionUID = -8937610402148135912L;

    private final String context;

    public OsgiHttpServiceCXFServlet(final String context) {
        this.context = context;
    }

    @Override
    protected DestinationFactory createServletTransportFactory() {
        if (this.servletTransportFactory == null) {
            this.servletTransportFactory = new OsgiCxfServletTransportFactory(this.bus, this.context);
        }
        return this.servletTransportFactory;
    }

    @Override
    public void loadBus(final ServletConfig servletConfig) throws ServletException {
        final ClassLoader bundleClassLoader = Bus.class.getClassLoader();
        final ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(bundleClassLoader);
        try {
            super.loadBus(servletConfig);
        } finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * (non-Javadoc)
     * @see
     * org.apache.cxf.transport.servlet.AbstractCXFServlet#doGet(javax.servlet
     * .http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doGet(final HttpServletRequest request, final HttpServletResponse response) throws ServletException {
        final ClassLoader bundleClassLoader = Bus.class.getClassLoader();
        final ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(bundleClassLoader);
        try {
            super.doGet(request, response);
        } finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * (non-Javadoc)
     * @see
     * org.apache.cxf.transport.servlet.AbstractCXFServlet#doPost(javax.servlet
     * .http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doPost(final HttpServletRequest request, final HttpServletResponse response) throws ServletException {
        final ClassLoader bundleClassLoader = Bus.class.getClassLoader();
        final ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(bundleClassLoader);
        try {
            super.doPost(request, response);
        } finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * (non-Javadoc)
     * @see
     * org.apache.cxf.transport.servlet.AbstractCXFServlet#doPut(javax.servlet
     * .http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doPut(final HttpServletRequest request, final HttpServletResponse response) throws ServletException,
        IOException {
        final ClassLoader bundleClassLoader = Bus.class.getClassLoader();
        final ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(bundleClassLoader);
        try {
            super.doPut(request, response);
        } finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * (non-Javadoc)
     * @see
     * org.apache.cxf.transport.servlet.AbstractCXFServlet#doDelete(javax.servlet
     * .http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doDelete(final HttpServletRequest request, final HttpServletResponse response) throws ServletException,
        IOException {
        final ClassLoader bundleClassLoader = Bus.class.getClassLoader();
        final ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(bundleClassLoader);
        try {
            super.doDelete(request, response);
        } finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

}
