/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="multicast")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MulticastDefinition
extends OutputDefinition<ProcessorDefinition> {
    @XmlAttribute(required=false)
    private Boolean parallelProcessing;
    @XmlAttribute(required=false)
    private String strategyRef;
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute(required=false)
    private String executorServiceRef;
    @XmlAttribute(required=false)
    private Boolean streaming;
    @XmlAttribute(required=false)
    private Boolean stopOnException;
    @XmlTransient
    private AggregationStrategy aggregationStrategy;

    public String toString() {
        return "Multicast[" + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "multicast";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        return this.createOutputsProcessor(routeContext);
    }

    public MulticastDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public MulticastDefinition parallelProcessing() {
        this.setParallelProcessing(true);
        return this;
    }

    public MulticastDefinition streaming() {
        this.setStreaming(true);
        return this;
    }

    public MulticastDefinition stopOnException() {
        this.setStopOnException(true);
        return this;
    }

    public MulticastDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    protected Processor createCompositeProcessor(RouteContext routeContext, List<Processor> list) throws Exception {
        if (this.strategyRef != null) {
            this.aggregationStrategy = routeContext.lookup(this.strategyRef, AggregationStrategy.class);
        }
        if (this.aggregationStrategy == null) {
            this.aggregationStrategy = new UseLatestAggregationStrategy();
        }
        if (this.executorServiceRef != null) {
            this.executorService = routeContext.lookup(this.executorServiceRef, ExecutorService.class);
        }
        return new MulticastProcessor(list, this.aggregationStrategy, this.isParallelProcessing(), this.executorService, this.isStreaming(), this.isStopOnException());
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public MulticastDefinition setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
        return this;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing != null ? this.parallelProcessing : false;
    }

    public void setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public boolean isStreaming() {
        return this.streaming != null ? this.streaming : false;
    }

    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    public Boolean isStopOnException() {
        return this.stopOnException != null ? this.stopOnException : false;
    }

    public void setStopOnException(Boolean stopOnException) {
        this.stopOnException = stopOnException;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

