/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.cxf.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.BusApplicationContext;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.apache.cxf.transport.servlet.ServletContextResourceResolver;
import org.ow2.jonas.camel.cxf.servlet.OsgiCxfServletTransportFactory;
import org.springframework.context.ApplicationListener;

public class OsgiHttpServiceCXFServlet
extends CXFServlet {
    private static final long serialVersionUID = -8937610402148135912L;
    private final String context;
    private final String busConfig;

    public OsgiHttpServiceCXFServlet(String context, String busConfig) {
        this.context = context;
        this.busConfig = busConfig;
    }

    protected DestinationFactory createServletTransportFactory() {
        if (this.servletTransportFactory == null) {
            this.servletTransportFactory = new OsgiCxfServletTransportFactory(this.bus, this.context);
        }
        return this.servletTransportFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBus(ServletConfig servletConfig) throws ServletException {
        ClassLoader bundleClassLoader = Bus.class.getClassLoader();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleClassLoader);
            String xmlCatalogFiles = System.getProperty("xml.catalog.files");
            try {
                System.setProperty("xml.catalog.files", "");
                this.bus = this.busConfig != null && !"".equals(this.busConfig) ? new SpringBusFactory().createBus(this.busConfig) : new SpringBusFactory().createBus();
            }
            finally {
                if (xmlCatalogFiles == null) {
                    System.clearProperty("xml.catalog.files");
                } else {
                    System.setProperty("xml.catalog.files", xmlCatalogFiles);
                }
            }
            BusApplicationContext ctx = (BusApplicationContext)this.bus.getExtension(BusApplicationContext.class);
            ResourceManager resourceManager = (ResourceManager)this.bus.getExtension(ResourceManager.class);
            resourceManager.addResourceResolver((ResourceResolver)new ServletContextResourceResolver(servletConfig.getServletContext()));
            this.replaceDestinationFactory();
            this.controller = this.createServletController(servletConfig);
            ctx.addApplicationListener((ApplicationListener)this);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ClassLoader bundleClassLoader = Bus.class.getClassLoader();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleClassLoader);
            super.doGet(request, response);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ClassLoader bundleClassLoader = Bus.class.getClassLoader();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleClassLoader);
            super.doPost(request, response);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ClassLoader bundleClassLoader = Bus.class.getClassLoader();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleClassLoader);
            super.doPut(request, response);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ClassLoader bundleClassLoader = Bus.class.getClassLoader();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleClassLoader);
            super.doDelete(request, response);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

