/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CxfUtils {
    private CxfUtils() {
    }

    public static String getStringFromInputStream(InputStream in) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bos);
        in.close();
        bos.close();
        return bos.getOut().toString();
    }

    public static String elementToString(Element element) throws Exception {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        CxfUtils.visitNodesForNameSpace(element, namespaces);
        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
        CxfUtils.writeElement(element, (XMLStreamWriter)writer, namespaces);
        XmlConverter converter = new XmlConverter();
        return converter.toString((Source)converter.toSource(writer.getDocument()));
    }

    private static void writeElement(Element e, XMLStreamWriter writer, Map<String, String> namespaces) throws XMLStreamException {
        boolean declareNamespace;
        String prefix = e.getPrefix();
        String ns = e.getNamespaceURI();
        String localName = e.getLocalName();
        if (prefix == null) {
            prefix = "";
        }
        if (localName == null && (localName = e.getNodeName()) == null) {
            throw new IllegalStateException("Element's local name cannot be null!");
        }
        String decUri = writer.getNamespaceContext().getNamespaceURI(prefix);
        boolean bl = declareNamespace = decUri == null || !decUri.equals(ns);
        if (ns == null || ns.length() == 0) {
            writer.writeStartElement(localName);
            if (StringUtils.isEmpty((String)decUri)) {
                declareNamespace = false;
            }
        } else {
            writer.writeStartElement(prefix, localName, ns);
        }
        NamedNodeMap attrs = e.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getLocalName();
            String attrPrefix = attr.getPrefix();
            if (attrPrefix == null) {
                attrPrefix = "";
            }
            if (name == null) {
                name = attr.getNodeName();
            }
            if ("xmlns".equals(attrPrefix)) {
                writer.writeNamespace(name, attr.getNodeValue());
                if (!name.equals(prefix) || !attr.getNodeValue().equals(ns)) continue;
                declareNamespace = false;
                continue;
            }
            if ("xmlns".equals(name) && "".equals(attrPrefix)) {
                writer.writeNamespace("", attr.getNodeValue());
                if (attr.getNodeValue().equals(ns)) {
                    declareNamespace = false;
                    continue;
                }
                if (!StringUtils.isEmpty((String)attr.getNodeValue()) || !StringUtils.isEmpty((String)ns)) continue;
                declareNamespace = false;
                continue;
            }
            String attns = attr.getNamespaceURI();
            String value = attr.getNodeValue();
            if (attns == null || attns.length() == 0) {
                writer.writeAttribute(name, value);
                continue;
            }
            if (attrPrefix == null || attrPrefix.length() == 0) {
                writer.writeAttribute(attns, name, value);
                continue;
            }
            writer.writeAttribute(attrPrefix, attns, name, value);
        }
        if (declareNamespace) {
            if (ns == null) {
                writer.writeNamespace(prefix, "");
            } else {
                writer.writeNamespace(prefix, ns);
            }
        }
        if (namespaces != null && namespaces.size() > 0) {
            for (String key : namespaces.keySet()) {
                String namespaceURI = namespaces.get(key);
                writer.writeNamespace(key, namespaceURI);
            }
        }
        for (Node nd = e.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            StaxUtils.writeNode((Node)nd, (XMLStreamWriter)writer, (boolean)false);
        }
        writer.writeEndElement();
    }

    private static void visitNodesForNameSpace(Node node, Map<String, String> namespaces) {
        if (node instanceof Element) {
            Element element = (Element)node;
            if (element.getPrefix() != null && element.getNamespaceURI() != null) {
                namespaces.put(element.getPrefix(), element.getNamespaceURI());
            }
            if (node.getChildNodes() != null) {
                NodeList nodelist = node.getChildNodes();
                for (int i = 0; i < nodelist.getLength(); ++i) {
                    CxfUtils.visitNodesForNameSpace(nodelist.item(i), namespaces);
                }
            }
        }
    }
}

