/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.dataset.DataSet;
import org.apache.camel.component.dataset.DataSetEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.processor.ThroughputLogger;

public class DataSetConsumer
extends DefaultConsumer {
    private DataSetEndpoint endpoint;
    private Processor reporter;

    public DataSetConsumer(DataSetEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.reporter == null) {
            this.reporter = this.createReporter();
        }
        final DataSet dataSet = this.endpoint.getDataSet();
        final long preloadSize = this.endpoint.getPreloadSize();
        this.sendMessages(0L, preloadSize);
        this.endpoint.getExecutorService().execute(new Runnable(){

            public void run() {
                if (DataSetConsumer.this.endpoint.getInitialDelay() > 0L) {
                    try {
                        Thread.sleep(DataSetConsumer.this.endpoint.getInitialDelay());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                DataSetConsumer.this.sendMessages(preloadSize, dataSet.getSize());
            }
        });
    }

    protected void sendMessages(long startIndex, long endIndex) {
        try {
            for (long i = startIndex; i < endIndex; ++i) {
                Exchange exchange;
                block5: {
                    exchange = this.endpoint.createExchange(i);
                    this.getProcessor().process(exchange);
                    try {
                        long delay = this.endpoint.getProduceDelay();
                        if (delay <= 0L) break block5;
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                if (this.reporter == null) continue;
                this.reporter.process(exchange);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected ThroughputLogger createReporter() {
        ThroughputLogger answer = new ThroughputLogger(this.endpoint.getEndpointUri(), (int)this.endpoint.getDataSet().getReportCount());
        answer.setAction("Sent");
        return answer;
    }
}

