/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.registry.xml.loader;

import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T loadSchemaAndFile(String xsdPath, Class<T> rootClass, InputStream xmlInputStream) throws Exception {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(rootClass.getClassLoader());
            JAXBContext jc = JAXBContext.newInstance((String)rootClass.getPackage().getName());
            Unmarshaller unMarshaller = jc.createUnmarshaller();
            URL xsdURL = rootClass.getClassLoader().getResource(xsdPath);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(xsdURL);
            unMarshaller.setSchema(schema);
            Object object = ((JAXBElement)unMarshaller.unmarshal(xmlInputStream)).getValue();
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }
}

