/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.stream.FileInputStreamCache;
import org.apache.camel.converter.stream.InputStreamCache;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachedOutputStream
extends OutputStream {
    public static final String THRESHOLD = "CamelCachedOutputStreamThreshold";
    public static final String TEMP_DIR = "CamelCachedOutputStreamOutputDirectory";
    private static final transient Log LOG = LogFactory.getLog(CachedOutputStream.class);
    private OutputStream currentStream = new ByteArrayOutputStream(2048);
    private boolean inMemory = true;
    private int totalLength;
    private File tempFile;
    private List<FileInputStreamCache> fileInputStreamCaches = new ArrayList<FileInputStreamCache>(4);
    private long threshold = 65536L;
    private File outputDir;

    public CachedOutputStream(Exchange exchange) {
        String hold = exchange.getContext().getProperties().get(THRESHOLD);
        String dir = exchange.getContext().getProperties().get(TEMP_DIR);
        if (hold != null) {
            this.threshold = exchange.getContext().getTypeConverter().convertTo(Long.class, hold);
        }
        if (dir != null) {
            this.outputDir = exchange.getContext().getTypeConverter().convertTo(File.class, dir);
        }
    }

    public void flush() throws IOException {
        this.currentStream.flush();
    }

    public void close() throws IOException {
        this.currentStream.close();
        try {
            if (this.tempFile != null) {
                boolean deleted = this.tempFile.delete();
                if (!deleted) {
                    LOG.warn((Object)("Cannot delete temporary cache file: " + this.tempFile));
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Deleted temporary cache file: " + this.tempFile));
                }
                this.tempFile = null;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Error deleting temporary cache file: " + this.tempFile), (Throwable)e);
        }
    }

    public boolean equals(Object obj) {
        return this.currentStream.equals(obj);
    }

    public int hashCode() {
        return this.currentStream.hashCode();
    }

    public String toString() {
        return "CachedOutputStream[size: " + this.totalLength + "]";
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.totalLength += len;
        if (this.threshold > 0L && this.inMemory && (long)this.totalLength > this.threshold && this.currentStream instanceof ByteArrayOutputStream) {
            this.pageToFileStream();
        }
        this.currentStream.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.totalLength += b.length;
        if (this.threshold > 0L && this.inMemory && (long)this.totalLength > this.threshold && this.currentStream instanceof ByteArrayOutputStream) {
            this.pageToFileStream();
        }
        this.currentStream.write(b);
    }

    public void write(int b) throws IOException {
        ++this.totalLength;
        if (this.threshold > 0L && this.inMemory && (long)this.totalLength > this.threshold && this.currentStream instanceof ByteArrayOutputStream) {
            this.pageToFileStream();
        }
        this.currentStream.write(b);
    }

    public InputStream getInputStream() throws IOException {
        this.flush();
        if (this.inMemory) {
            if (this.currentStream instanceof ByteArrayOutputStream) {
                return new ByteArrayInputStream(((ByteArrayOutputStream)this.currentStream).toByteArray());
            }
            throw new IllegalStateException("CurrentStream should be an instance of ByteArrayOutputStream but is: " + this.currentStream.getClass().getName());
        }
        try {
            FileInputStreamCache answer = new FileInputStreamCache(this.tempFile, this);
            this.fileInputStreamCaches.add(answer);
            return answer;
        }
        catch (FileNotFoundException e) {
            throw IOHelper.createIOException("Cached file " + this.tempFile + " not found", e);
        }
    }

    public StreamCache getStreamCache() throws IOException {
        this.flush();
        if (this.inMemory) {
            if (this.currentStream instanceof ByteArrayOutputStream) {
                return new InputStreamCache(((ByteArrayOutputStream)this.currentStream).toByteArray());
            }
            throw new IllegalStateException("CurrentStream should be an instance of ByteArrayOutputStream but is: " + this.currentStream.getClass().getName());
        }
        try {
            FileInputStreamCache answer = new FileInputStreamCache(this.tempFile, this);
            this.fileInputStreamCaches.add(answer);
            return answer;
        }
        catch (FileNotFoundException e) {
            throw IOHelper.createIOException("Cached file " + this.tempFile + " not found", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pageToFileStream() throws IOException {
        this.flush();
        ByteArrayOutputStream bout = (ByteArrayOutputStream)this.currentStream;
        this.tempFile = this.outputDir == null ? FileUtil.createTempFile("cos", ".tmp") : FileUtil.createTempFile("cos", ".tmp", this.outputDir);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Creating temporary stream cache file: " + this.tempFile));
        }
        try {
            this.currentStream = new BufferedOutputStream(new FileOutputStream(this.tempFile));
            bout.writeTo(this.currentStream);
        }
        finally {
            this.inMemory = false;
        }
    }
}

