/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Service;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.impl.DefaultTracedRouteNodes;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.SynchronizationVetoable;
import org.apache.camel.spi.TracedRouteNodes;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.UuidGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUnitOfWork
implements UnitOfWork,
Service {
    private static final transient Log LOG = LogFactory.getLog(DefaultUnitOfWork.class);
    private String id;
    private List<Synchronization> synchronizations;
    private Message originalInMessage;
    private final TracedRouteNodes tracedRouteNodes;
    private Set<Object> transactedBy;
    private final Stack<RouteContext> routeContextStack = new Stack();

    public DefaultUnitOfWork(Exchange exchange) {
        this.tracedRouteNodes = new DefaultTracedRouteNodes();
        if (exchange.getIn().getClass().getSimpleName().equals("JmsMessage")) {
            this.originalInMessage = new DefaultMessage();
            this.originalInMessage.setBody(exchange.getIn().getBody());
        } else {
            this.originalInMessage = exchange.getIn().copy();
        }
        EventHelper.notifyExchangeCreated(exchange.getContext(), exchange);
        if (exchange.getContext() != null) {
            exchange.getContext().getInflightRepository().add(exchange);
        }
    }

    @Override
    public void start() throws Exception {
        this.id = null;
    }

    @Override
    public void stop() throws Exception {
        if (this.synchronizations != null) {
            this.synchronizations.clear();
        }
        if (this.tracedRouteNodes != null) {
            this.tracedRouteNodes.clear();
        }
        if (this.transactedBy != null) {
            this.transactedBy.clear();
        }
        this.originalInMessage = null;
        if (!this.routeContextStack.isEmpty()) {
            this.routeContextStack.clear();
        }
    }

    @Override
    public synchronized void addSynchronization(Synchronization synchronization) {
        if (this.synchronizations == null) {
            this.synchronizations = new ArrayList<Synchronization>();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Adding synchronization " + synchronization));
        }
        this.synchronizations.add(synchronization);
    }

    @Override
    public synchronized void removeSynchronization(Synchronization synchronization) {
        if (this.synchronizations != null) {
            this.synchronizations.remove(synchronization);
        }
    }

    @Override
    public void handoverSynchronization(Exchange target) {
        if (this.synchronizations == null || this.synchronizations.isEmpty()) {
            return;
        }
        Iterator<Synchronization> it = this.synchronizations.iterator();
        while (it.hasNext()) {
            Synchronization synchronization = it.next();
            boolean handover = true;
            if (synchronization instanceof SynchronizationVetoable) {
                SynchronizationVetoable veto = (SynchronizationVetoable)synchronization;
                handover = veto.allowHandover();
            }
            if (handover) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Handover synchronization " + synchronization + " to Exchange: " + target));
                }
                target.addOnCompletion(synchronization);
                it.remove();
                continue;
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("Handover not allow for synchronization " + synchronization));
        }
    }

    @Override
    public void done(Exchange exchange) {
        boolean failed = exchange.isFailed();
        try {
            if (failed) {
                EventHelper.notifyExchangeFailed(exchange.getContext(), exchange);
            } else {
                EventHelper.notifyExchangeDone(exchange.getContext(), exchange);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception occurred during event notification. This exception will be ignored.", (Throwable)e);
        }
        if (this.synchronizations != null && !this.synchronizations.isEmpty()) {
            Collections.reverse(this.synchronizations);
            for (Synchronization synchronization : this.synchronizations) {
                try {
                    if (failed) {
                        synchronization.onFailure(exchange);
                        continue;
                    }
                    synchronization.onComplete(exchange);
                }
                catch (Exception e) {
                    LOG.warn((Object)"Exception occurred during onCompletion. This exception will be ignored.", (Throwable)e);
                }
            }
        }
        if (exchange.getContext() != null) {
            exchange.getContext().getInflightRepository().remove(exchange);
        }
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = UuidGenerator.get().generateUuid();
        }
        return this.id;
    }

    @Override
    public Message getOriginalInMessage() {
        return this.originalInMessage;
    }

    @Override
    public TracedRouteNodes getTracedRouteNodes() {
        return this.tracedRouteNodes;
    }

    @Override
    public boolean isTransactedBy(Object transactionDefinition) {
        return this.getTransactedBy().contains(transactionDefinition);
    }

    @Override
    public void beginTransactedBy(Object transactionDefinition) {
        this.getTransactedBy().add(transactionDefinition);
    }

    @Override
    public void endTransactedBy(Object transactionDefinition) {
        this.getTransactedBy().remove(transactionDefinition);
    }

    @Override
    public RouteContext getRouteContext() {
        if (this.routeContextStack.isEmpty()) {
            return null;
        }
        return this.routeContextStack.peek();
    }

    @Override
    public void pushRouteContext(RouteContext routeContext) {
        this.routeContextStack.add(routeContext);
    }

    @Override
    public RouteContext popRouteContext() {
        if (this.routeContextStack.isEmpty()) {
            return null;
        }
        return this.routeContextStack.pop();
    }

    private Set<Object> getTransactedBy() {
        if (this.transactedBy == null) {
            this.transactedBy = new LinkedHashSet<Object>();
        }
        return this.transactedBy;
    }
}

