/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerCallback;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.ServicePool;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerCache
extends ServiceSupport {
    private static final transient Log LOG = LogFactory.getLog(ProducerCache.class);
    private final CamelContext camelContext;
    private final ServicePool<Endpoint, Producer> pool;
    private final Map<String, Producer> producers;
    private final Object source;

    public ProducerCache(Object source, CamelContext camelContext) {
        this(source, camelContext, CamelContextHelper.getMaximumCachePoolSize(camelContext));
    }

    public ProducerCache(Object source, CamelContext camelContext, int cacheSize) {
        this(source, camelContext, camelContext.getProducerServicePool(), new LRUCache<String, Producer>(cacheSize));
    }

    public ProducerCache(Object source, CamelContext camelContext, ServicePool<Endpoint, Producer> producerServicePool, Map<String, Producer> cache) {
        this.source = source;
        this.camelContext = camelContext;
        this.pool = producerServicePool;
        this.producers = cache;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Object getSource() {
        return this.source;
    }

    public Producer acquireProducer(Endpoint endpoint) {
        return this.doGetProducer(endpoint, true);
    }

    public void releaseProducer(Endpoint endpoint, Producer producer) throws Exception {
        if (producer instanceof ServicePoolAware) {
            this.pool.release(endpoint, producer);
        } else if (!producer.isSingleton()) {
            producer.stop();
        }
    }

    public void send(Endpoint endpoint, Exchange exchange) {
        try {
            this.sendExchange(endpoint, null, null, exchange);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    public Exchange send(Endpoint endpoint, Processor processor) {
        try {
            return this.sendExchange(endpoint, null, processor, null);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    public Exchange send(Endpoint endpoint, ExchangePattern pattern, Processor processor) {
        try {
            return this.sendExchange(endpoint, pattern, processor, null);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doInProducer(Endpoint endpoint, Exchange exchange, ExchangePattern pattern, ProducerCallback<T> callback) throws Exception {
        Producer producer = this.doGetProducer(endpoint, true);
        if (producer == null) {
            if (this.isStopped()) {
                LOG.warn((Object)("Ignoring exchange sent after processor is stopped: " + exchange));
                return null;
            }
            throw new IllegalStateException("No producer, this processor has not been started: " + this);
        }
        StopWatch watch = null;
        if (exchange != null) {
            watch = new StopWatch();
        }
        try {
            T t = callback.doInProducer(producer, exchange, pattern);
            return t;
        }
        finally {
            if (exchange != null) {
                long timeTaken = watch.stop();
                EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint, timeTaken);
            }
            if (producer instanceof ServicePoolAware) {
                this.pool.release(endpoint, producer);
            } else if (!producer.isSingleton()) {
                producer.stop();
            }
        }
    }

    protected Exchange sendExchange(final Endpoint endpoint, ExchangePattern pattern, final Processor processor, Exchange exchange) throws Exception {
        return this.doInProducer(endpoint, exchange, pattern, new ProducerCallback<Exchange>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Exchange doInProducer(Producer producer, Exchange exchange, ExchangePattern pattern) throws Exception {
                if (exchange == null) {
                    Exchange exchange2 = exchange = pattern != null ? producer.createExchange(pattern) : producer.createExchange();
                }
                if (processor != null) {
                    processor.process(exchange);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(">>>> " + endpoint + " " + exchange));
                }
                exchange.setProperty("CamelToEndpoint", endpoint.getEndpointUri());
                StopWatch watch = new StopWatch();
                try {
                    producer.process(exchange);
                }
                finally {
                    long timeTaken = watch.stop();
                    EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint, timeTaken);
                }
                return exchange;
            }
        });
    }

    protected synchronized Producer doGetProducer(Endpoint endpoint, boolean pooled) {
        String key = endpoint.getEndpointUri();
        Producer answer = this.producers.get(key);
        if (pooled && answer == null) {
            answer = this.pool.acquire(endpoint);
        }
        if (answer == null) {
            try {
                answer = endpoint.createProducer();
                ServiceHelper.startService(answer);
            }
            catch (Exception e) {
                throw new FailedToCreateProducerException(endpoint, (Throwable)e);
            }
            if (pooled && answer instanceof ServicePoolAware) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding to producer service pool with key: " + endpoint + " for producer: " + answer));
                }
                answer = this.pool.addAndAcquire(endpoint, answer);
            } else if (answer.isSingleton()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding to producer cache with key: " + endpoint + " for producer: " + answer));
                }
                this.producers.put(key, answer);
            }
        }
        return answer;
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.producers, this.pool);
        this.producers.clear();
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.pool, this.producers);
    }

    public int size() {
        int size = this.producers.size();
        size += this.pool.size();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("size = " + size));
        }
        return size;
    }

    public int getCapacity() {
        int capacity = -1;
        if (this.producers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.producers;
            capacity = cache.getMaxCacheSize();
        }
        return capacity;
    }

    public String toString() {
        return "ProducerCache for source: " + this.source;
    }
}

