/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.event;

import java.util.EventObject;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;

public class ExchangeFailureHandledEvent
extends EventObject {
    private static final long serialVersionUID = -7554809462006009547L;
    private final Exchange exchange;
    private final Processor failureHandler;
    private final boolean deadLetterChannel;
    private final boolean handled;

    public ExchangeFailureHandledEvent(Exchange source, Processor failureHandler, boolean deadLetterChannel) {
        super(source);
        this.exchange = source;
        this.failureHandler = failureHandler;
        this.deadLetterChannel = deadLetterChannel;
        this.handled = this.exchange.getProperty("CamelErrorHandlerHandled", false, Boolean.class);
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public Processor getFailureHandler() {
        return this.failureHandler;
    }

    public boolean isDeadLetterChannel() {
        return this.deadLetterChannel;
    }

    public boolean isHandled() {
        return this.handled;
    }

    public String toString() {
        if (this.isDeadLetterChannel()) {
            return this.exchange.getExchangeId() + " exchange failed: " + this.exchange + " but was handled by dead letter channel: " + this.failureHandler;
        }
        return this.exchange.getExchangeId() + " exchange failed: " + this.exchange + " but was processed by: " + this.failureHandler;
    }
}

