/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.SynchronizationAdapter;
import org.apache.camel.processor.Traceable;
import org.apache.camel.processor.UnitOfWorkProcessor;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OnCompletionProcessor
extends ServiceSupport
implements Processor,
Traceable {
    private static final transient Log LOG = LogFactory.getLog(OnCompletionProcessor.class);
    private final CamelContext camelContext;
    private final Processor processor;
    private final ExecutorService executorService;
    private boolean onCompleteOnly;
    private boolean onFailureOnly;
    private Predicate onWhen;

    public OnCompletionProcessor(CamelContext camelContext, Processor processor, ExecutorService executorService, boolean onCompleteOnly, boolean onFailureOnly, Predicate onWhen) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(processor, "processor");
        ObjectHelper.notNull(executorService, "executorService");
        this.camelContext = camelContext;
        this.processor = new UnitOfWorkProcessor(processor);
        this.executorService = executorService;
        this.onCompleteOnly = onCompleteOnly;
        this.onFailureOnly = onFailureOnly;
        this.onWhen = onWhen;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService(this.processor);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.processor);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void process(Exchange exchange) throws Exception {
        if (this.processor == null) {
            return;
        }
        exchange.getUnitOfWork().addSynchronization(new SynchronizationAdapter(){

            public void onComplete(Exchange exchange) {
                if (OnCompletionProcessor.this.onFailureOnly) {
                    return;
                }
                if (OnCompletionProcessor.this.onWhen != null && !OnCompletionProcessor.this.onWhen.matches(exchange)) {
                    return;
                }
                final Exchange copy = OnCompletionProcessor.this.prepareExchange(exchange);
                OnCompletionProcessor.this.executorService.submit(new Callable<Exchange>(){

                    @Override
                    public Exchange call() throws Exception {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Processing onComplete: " + copy));
                        }
                        OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                        return copy;
                    }
                });
            }

            public void onFailure(Exchange exchange) {
                if (OnCompletionProcessor.this.onCompleteOnly) {
                    return;
                }
                if (OnCompletionProcessor.this.onWhen != null && !OnCompletionProcessor.this.onWhen.matches(exchange)) {
                    return;
                }
                final Exchange copy = OnCompletionProcessor.this.prepareExchange(exchange);
                copy.setException(null);
                OnCompletionProcessor.this.executorService.submit(new Callable<Exchange>(){

                    @Override
                    public Exchange call() throws Exception {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Processing onFailure: " + copy));
                        }
                        OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                        return copy;
                    }
                });
            }

            public String toString() {
                if (!OnCompletionProcessor.this.onCompleteOnly && !OnCompletionProcessor.this.onFailureOnly) {
                    return "onCompleteOrFailure";
                }
                if (OnCompletionProcessor.this.onCompleteOnly) {
                    return "onCompleteOnly";
                }
                return "onFailureOnly";
            }
        });
    }

    protected static void doProcess(Processor processor, Exchange exchange) {
        try {
            processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
    }

    protected Exchange prepareExchange(Exchange exchange) {
        Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, false);
        copy.setPattern(ExchangePattern.InOnly);
        copy.setProperty("CamelOnCompletion", Boolean.TRUE);
        return copy;
    }

    public String toString() {
        return "OnCompletionProcessor[" + this.processor + "]";
    }

    public String getTraceLabel() {
        return "onCompletion";
    }
}

