/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EndpointHelper {
    private static final transient Log LOG = LogFactory.getLog(EndpointHelper.class);

    private EndpointHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pollEndpoint(Endpoint endpoint, Processor processor, long timeout) throws Exception {
        PollingConsumer consumer = endpoint.createPollingConsumer();
        try {
            Exchange exchange;
            consumer.start();
            while ((exchange = consumer.receive(timeout)) != null) {
                processor.process(exchange);
            }
        }
        finally {
            try {
                consumer.stop();
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to stop PollingConsumer: " + e), (Throwable)e);
            }
        }
    }

    public static void pollEndpoint(Endpoint endpoint, Processor processor) throws Exception {
        EndpointHelper.pollEndpoint(endpoint, processor, 1000L);
    }

    public static boolean matchEndpoint(String uri, String pattern) {
        try {
            uri = URISupport.normalizeUri(uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, e);
        }
        if (uri.indexOf("://") != -1) {
            String scheme = ObjectHelper.before(uri, "://");
            String path = ObjectHelper.after(uri, "://");
            if (EndpointHelper.matchPattern(scheme + ":" + path, pattern)) {
                return true;
            }
        } else {
            String scheme = ObjectHelper.before(uri, ":");
            String path = ObjectHelper.after(uri, ":");
            if (EndpointHelper.matchPattern(scheme + "://" + path, pattern)) {
                return true;
            }
        }
        return EndpointHelper.matchPattern(uri, pattern);
    }

    public static boolean matchPattern(String name, String pattern) {
        if (name.equals(pattern)) {
            return true;
        }
        if (pattern.endsWith("*") && name.startsWith(pattern.substring(0, pattern.length() - 1))) {
            return true;
        }
        try {
            if (name.matches(pattern)) {
                return true;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return false;
    }

    public static void setProperties(CamelContext context, Object bean, Map<String, Object> parameters) throws Exception {
        IntrospectionSupport.setProperties(context.getTypeConverter(), bean, parameters);
    }

    public static void setReferenceProperties(CamelContext context, Object bean, Map<String, Object> parameters) throws Exception {
        Iterator<Map.Entry<String, Object>> it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            boolean hit;
            Object ref;
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            Object v = entry.getValue();
            String value = v != null ? v.toString() : null;
            if (value == null || !EndpointHelper.isReferenceParameter(value) || (ref = EndpointHelper.resolveReferenceParameter(context, value, Object.class, false)) == null || !(hit = IntrospectionSupport.setProperty(context.getTypeConverter(), bean, name, ref))) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Configured property: " + name + " on bean: " + bean + " with value: " + ref));
            }
            it.remove();
        }
    }

    public static boolean isReferenceParameter(String parameter) {
        return parameter != null && parameter.trim().startsWith("#");
    }

    public static <T> T resolveReferenceParameter(CamelContext context, String value, Class<T> type) {
        return EndpointHelper.resolveReferenceParameter(context, value, type, true);
    }

    public static <T> T resolveReferenceParameter(CamelContext context, String value, Class<T> type, boolean mandatory) {
        String valueNoHash = value.replaceAll("#", "");
        if (mandatory) {
            return CamelContextHelper.mandatoryLookup(context, valueNoHash, type);
        }
        return CamelContextHelper.lookup(context, valueNoHash, type);
    }

    public static <T> List<T> resolveReferenceListParameter(CamelContext context, String value, Class<T> elementType) {
        if (value == null) {
            return Collections.emptyList();
        }
        List<String> elements = Arrays.asList(value.split(","));
        if (elements.size() == 1) {
            Object bean = EndpointHelper.resolveReferenceParameter(context, elements.get(0).trim(), Object.class);
            if (bean instanceof List) {
                return (List)bean;
            }
            return Arrays.asList(elementType.cast(bean));
        }
        ArrayList<T> result = new ArrayList<T>(elements.size());
        for (String element : elements) {
            result.add(EndpointHelper.resolveReferenceParameter(context, element.trim(), elementType));
        }
        return result;
    }
}

