/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import java.util.Map;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.Logger;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TransactedPolicy;
import org.apache.camel.spring.spi.SpringTransactionPolicy;
import org.apache.camel.spring.spi.TransactionErrorHandler;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionErrorHandlerBuilder
extends DefaultErrorHandlerBuilder {
    private static final transient Log LOG = LogFactory.getLog(TransactionErrorHandlerBuilder.class);
    private static final String PROPAGATION_REQUIRED = "PROPAGATION_REQUIRED";
    private TransactionTemplate transactionTemplate;

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public boolean supportTransacted() {
        return true;
    }

    public Processor createErrorHandler(RouteContext routeContext, Processor processor) throws Exception {
        if (this.transactionTemplate == null) {
            TransactedPolicy policy;
            TransactedPolicy policy2;
            Map map;
            LOG.debug((Object)"No TransactionTemplate configured on TransactionErrorHandlerBuilder. Will try find it in the registry.");
            if (this.transactionTemplate == null && (map = routeContext.lookupByType(TransactedPolicy.class)) != null && map.size() == 1 && (policy2 = (TransactedPolicy)map.values().iterator().next()) != null && policy2 instanceof SpringTransactionPolicy) {
                this.transactionTemplate = ((SpringTransactionPolicy)policy2).getTransactionTemplate();
            }
            if (this.transactionTemplate == null && (policy = (TransactedPolicy)routeContext.lookup(PROPAGATION_REQUIRED, TransactedPolicy.class)) != null && policy instanceof SpringTransactionPolicy) {
                this.transactionTemplate = ((SpringTransactionPolicy)policy).getTransactionTemplate();
            }
            if (this.transactionTemplate == null) {
                map = routeContext.lookupByType(TransactionTemplate.class);
                if (map != null && map.size() == 1) {
                    this.transactionTemplate = (TransactionTemplate)map.values().iterator().next();
                } else if (LOG.isDebugEnabled()) {
                    if (map == null || map.isEmpty()) {
                        LOG.trace((Object)"No TransactionTemplate found in registry.");
                    } else {
                        LOG.debug((Object)("Found " + map.size() + " TransactionTemplate in registry. " + "Cannot determine which one to use. Please configure a TransactionTemplate on the TransactionErrorHandlerBuilder"));
                    }
                }
            }
            if (this.transactionTemplate == null) {
                map = routeContext.lookupByType(PlatformTransactionManager.class);
                if (map != null && map.size() == 1) {
                    this.transactionTemplate = new TransactionTemplate((PlatformTransactionManager)map.values().iterator().next());
                } else if (LOG.isDebugEnabled()) {
                    if (map == null || map.isEmpty()) {
                        LOG.trace((Object)"No PlatformTransactionManager found in registry.");
                    } else {
                        LOG.debug((Object)("Found " + map.size() + " PlatformTransactionManager in registry. " + "Cannot determine which one to use for TransactionTemplate. Please configure a TransactionTemplate on the TransactionErrorHandlerBuilder"));
                    }
                }
            }
            if (this.transactionTemplate != null) {
                LOG.debug((Object)("Found TransactionTemplate in registry to use: " + this.transactionTemplate));
            }
        }
        ObjectHelper.notNull((Object)this.transactionTemplate, (String)"transactionTemplate", (Object)((Object)this));
        TransactionErrorHandler answer = new TransactionErrorHandler(processor, this.getLogger(), this.getOnRedelivery(), this.getRedeliveryPolicy(), this.getHandledPolicy(), this.getExceptionPolicyStrategy(), this.transactionTemplate);
        this.configure((ErrorHandler)answer);
        return answer;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void setSpringTransactionPolicy(SpringTransactionPolicy policy) {
        this.transactionTemplate = policy.getTransactionTemplate();
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionTemplate = new TransactionTemplate(transactionManager);
    }

    protected Logger createLogger() {
        return new Logger(LogFactory.getLog(TransactionErrorHandler.class), LoggingLevel.ERROR);
    }

    public String toString() {
        return "TransactionErrorHandlerBuilder";
    }
}

