/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.jdbc.JdbcEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(JdbcProducer.class);
    private DataSource dataSource;
    private int readSize;
    private Map<String, Object> parameters;

    public JdbcProducer(JdbcEndpoint endpoint, DataSource dataSource, int readSize, Map<String, Object> parameters) throws Exception {
        super((Endpoint)endpoint);
        this.dataSource = dataSource;
        this.readSize = readSize;
        this.parameters = parameters;
    }

    public JdbcEndpoint getEndpoint() {
        return (JdbcEndpoint)super.getEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        String sql = (String)exchange.getIn().getBody(String.class);
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.createStatement();
            if (this.parameters != null && !this.parameters.isEmpty()) {
                IntrospectionSupport.setProperties((Object)stmt, this.parameters);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Executing JDBC statement: " + sql));
            }
            exchange.getOut().setHeaders(exchange.getIn().getHeaders());
            if (stmt.execute(sql)) {
                rs = stmt.getResultSet();
                this.setResultSet(exchange, rs);
            } else {
                int updateCount = stmt.getUpdateCount();
                exchange.getOut().setHeader("CamelJdbcUpdateCount", (Object)updateCount);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                LOG.warn((Object)("Error closing JDBC resource: " + e), (Throwable)e);
            }
        }
    }

    protected void setResultSet(Exchange exchange, ResultSet rs) throws SQLException {
        int rowNumber;
        ResultSetMetaData meta = rs.getMetaData();
        boolean jdbc4 = this.getEndpoint().isUseJDBC4ColumnNameAndLabelSemantics();
        int count = meta.getColumnCount();
        ArrayList data = new ArrayList();
        for (rowNumber = 0; rs.next() && (this.readSize == 0 || rowNumber < this.readSize); ++rowNumber) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int i = 0; i < count; ++i) {
                String columnName;
                int columnNumber = i + 1;
                if (jdbc4) {
                    columnName = meta.getColumnLabel(columnNumber);
                } else {
                    try {
                        columnName = meta.getColumnLabel(columnNumber);
                    }
                    catch (SQLException e) {
                        columnName = meta.getColumnName(columnNumber);
                    }
                }
                row.put(columnName, rs.getObject(columnNumber));
            }
            data.add(row);
        }
        exchange.getOut().setHeader("CamelJdbcRowCount", (Object)rowNumber);
        exchange.getOut().setBody(data);
    }
}

