/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileMessage;
import org.apache.camel.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteFile<T>
extends GenericFile<T>
implements Cloneable {
    private String hostname;

    public void populateHeaders(GenericFileMessage<T> message) {
        if (message != null) {
            super.populateHeaders(message);
            message.setHeader("CamelFileHost", (Object)this.getHostname());
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public char getFileSeparator() {
        return '/';
    }

    protected boolean isAbsolute(String name) {
        return name.startsWith("" + this.getFileSeparator());
    }

    protected String normalizePath(String name) {
        return name;
    }

    public void copyFromPopulateAdditional(GenericFile source, GenericFile result) {
        RemoteFile remoteSource = (RemoteFile)source;
        RemoteFile remoteResult = (RemoteFile)result;
        remoteResult.setHostname(remoteSource.getHostname());
    }

    protected String normalizePathToProtocol(String path) {
        path = super.normalizePathToProtocol(path);
        return FileUtil.stripLeadingSeparator((String)path);
    }
}

