/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.net.URI;
import org.apache.camel.component.file.GenericFileConfiguration;
import org.apache.camel.util.FileUtil;

public abstract class RemoteFileConfiguration
extends GenericFileConfiguration {
    private String protocol;
    private String username;
    private String host;
    private int port;
    private String password;
    private boolean binary;
    private boolean passiveMode;

    public RemoteFileConfiguration() {
    }

    public RemoteFileConfiguration(URI uri) {
        this.configure(uri);
    }

    public boolean needToNormalize() {
        return false;
    }

    public void configure(URI uri) {
        super.configure(uri);
        this.setProtocol(uri.getScheme());
        this.setDefaultPort();
        this.setUsername(uri.getUserInfo());
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
    }

    public void setDirectory(String directory) {
        super.setDirectory(directory);
        super.setDirectory(FileUtil.stripLeadingSeparator((String)this.getDirectory()));
    }

    public String remoteServerInformation() {
        return this.protocol + "://" + (this.username != null ? this.username : "anonymous") + "@" + this.host + ":" + this.getPort();
    }

    protected abstract void setDefaultPort();

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port > 0) {
            this.port = port;
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public void setPassiveMode(boolean passiveMode) {
        this.passiveMode = passiveMode;
    }
}

