/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateProcessor;

@Converter
public final class AsyncProcessorConverter {
    private AsyncProcessorConverter() {
    }

    @Converter
    public static AsyncProcessor toAsyncProcessor(Processor processor) {
        if (processor instanceof AsyncProcessor) {
            return (AsyncProcessor)processor;
        }
        return new ProcessorToAsyncProcessorBridge(processor);
    }

    private static final class ProcessorToAsyncProcessorBridge
    extends DelegateProcessor
    implements AsyncProcessor {
        private ProcessorToAsyncProcessorBridge(Processor processor) {
            super(processor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(Exchange exchange, AsyncCallback callback) throws Exception {
            try {
                this.processor.process(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
            finally {
                callback.onTaskCompleted(exchange);
            }
        }
    }
}

