/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.camel.component.file.remote.FtpEndpoint;
import org.apache.camel.component.file.remote.FtpsConfiguration;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPSClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpsEndpoint
extends FtpEndpoint<FTPFile> {
    protected Map<String, Object> ftpClientKeyStoreParameters;
    protected Map<String, Object> ftpClientTrustStoreParameters;

    public FtpsEndpoint() {
    }

    public FtpsEndpoint(String uri, RemoteFileComponent<FTPFile> remoteFileComponent, RemoteFileConfiguration configuration) {
        super(uri, remoteFileComponent, configuration);
    }

    @Override
    public String getScheme() {
        return this.getFtpsConfiguration().getProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FTPClient createFtpClient() throws Exception {
        String algorithm;
        String password;
        String file;
        String type;
        FTPSClient client = new FTPSClient(this.getFtpsConfiguration().getSecurityProtocol(), this.getFtpsConfiguration().isImplicit());
        if (this.ftpClientKeyStoreParameters != null) {
            type = this.ftpClientKeyStoreParameters.containsKey("type") ? (String)this.ftpClientKeyStoreParameters.get("type") : KeyStore.getDefaultType();
            file = (String)this.ftpClientKeyStoreParameters.get("file");
            password = (String)this.ftpClientKeyStoreParameters.get("password");
            algorithm = this.ftpClientKeyStoreParameters.containsKey("algorithm") ? (String)this.ftpClientKeyStoreParameters.get("algorithm") : KeyManagerFactory.getDefaultAlgorithm();
            String keyPassword = (String)this.ftpClientKeyStoreParameters.get("keyPassword");
            KeyStore keyStore = KeyStore.getInstance(type);
            FileInputStream keyStoreFileInputStream = new FileInputStream(new File(file));
            try {
                keyStore.load(keyStoreFileInputStream, password.toCharArray());
            }
            finally {
                ObjectHelper.close((Closeable)keyStoreFileInputStream, (String)"keyStore", (Log)this.log);
            }
            KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance(algorithm);
            keyMgrFactory.init(keyStore, keyPassword.toCharArray());
            client.setNeedClientAuth(true);
            client.setKeyManager(keyMgrFactory.getKeyManagers()[0]);
        }
        if (this.ftpClientTrustStoreParameters != null) {
            type = this.ftpClientTrustStoreParameters.containsKey("type") ? (String)this.ftpClientTrustStoreParameters.get("type") : KeyStore.getDefaultType();
            file = (String)this.ftpClientTrustStoreParameters.get("file");
            password = (String)this.ftpClientTrustStoreParameters.get("password");
            algorithm = this.ftpClientTrustStoreParameters.containsKey("algorithm") ? (String)this.ftpClientTrustStoreParameters.get("algorithm") : TrustManagerFactory.getDefaultAlgorithm();
            KeyStore trustStore = KeyStore.getInstance(type);
            FileInputStream trustStoreFileInputStream = new FileInputStream(new File(file));
            try {
                trustStore.load(trustStoreFileInputStream, password.toCharArray());
            }
            finally {
                ObjectHelper.close((Closeable)trustStoreFileInputStream, (String)"trustStore", (Log)this.log);
            }
            TrustManagerFactory trustMgrFactory = TrustManagerFactory.getInstance(algorithm);
            trustMgrFactory.init(trustStore);
            client.setTrustManager(trustMgrFactory.getTrustManagers()[0]);
        }
        return client;
    }

    public FTPSClient getFtpsClient() {
        return (FTPSClient)this.getFtpClient();
    }

    public FtpsConfiguration getFtpsConfiguration() {
        return (FtpsConfiguration)this.getConfiguration();
    }

    public void setFtpClientKeyStoreParameters(Map<String, Object> param) {
        this.ftpClientKeyStoreParameters = param;
    }

    public void setFtpClientTrustStoreParameters(Map<String, Object> param) {
        this.ftpClientTrustStoreParameters = param;
    }
}

