/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.processor.SendAsyncProcessor;
import org.apache.camel.processor.UnitOfWorkProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="to")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ToDefinition
extends SendDefinition<ToDefinition>
implements ExecutorServiceAwareDefinition<ToDefinition> {
    @XmlTransient
    private final List<ProcessorDefinition> outputs = new ArrayList<ProcessorDefinition>();
    @XmlAttribute(required=false)
    private ExchangePattern pattern;
    @XmlAttribute(required=false)
    @Deprecated
    private Boolean async = Boolean.FALSE;
    @XmlTransient
    @Deprecated
    private ExecutorService executorService;
    @XmlAttribute(required=false)
    @Deprecated
    private String executorServiceRef;
    @XmlAttribute(required=false)
    @Deprecated
    private Integer poolSize;

    public ToDefinition() {
    }

    public ToDefinition(String uri) {
        this.setUri(uri);
    }

    public ToDefinition(Endpoint endpoint) {
        this.setEndpoint(endpoint);
    }

    public ToDefinition(String uri, ExchangePattern pattern) {
        this(uri);
        this.pattern = pattern;
    }

    public ToDefinition(Endpoint endpoint, ExchangePattern pattern) {
        this(endpoint);
        this.pattern = pattern;
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return this.outputs;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        if (this.async == null || !this.async.booleanValue()) {
            return super.createProcessor(routeContext);
        }
        Processor childProcessor = this.createChildProcessor(routeContext, false);
        UnitOfWorkProcessor uow = new UnitOfWorkProcessor(routeContext, childProcessor);
        Endpoint endpoint = this.resolveEndpoint(routeContext);
        SendAsyncProcessor async = new SendAsyncProcessor(endpoint, this.getPattern(), uow);
        this.executorService = ExecutorServiceHelper.getConfiguredExecutorService(routeContext, "ToAsync", this);
        if (this.executorService != null) {
            async.setExecutorService(this.executorService);
        }
        if (this.poolSize != null) {
            async.setPoolSize(this.poolSize);
        }
        return async;
    }

    public String toString() {
        if (this.async != null && this.async.booleanValue()) {
            return "ToAsync[" + this.getLabel() + "] -> " + this.getOutputs();
        }
        return "To[" + this.getLabel() + "]";
    }

    @Override
    public String getShortName() {
        return "to";
    }

    @Override
    public ExchangePattern getPattern() {
        return this.pattern;
    }

    @Deprecated
    public Boolean isAsync() {
        return this.async;
    }

    @Deprecated
    public void setAsync(Boolean async) {
        this.async = async;
    }

    @Deprecated
    public Integer getPoolSize() {
        return this.poolSize;
    }

    @Deprecated
    public void setPoolSize(Integer poolSize) {
        this.poolSize = poolSize;
    }

    @Override
    @Deprecated
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    @Deprecated
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    @Deprecated
    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    @Override
    @Deprecated
    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public ToDefinition pattern(ExchangePattern pattern) {
        this.setPattern(pattern);
        return this;
    }

    @Override
    @Deprecated
    public ToDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    @Deprecated
    public ToDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    @Deprecated
    public ToDefinition poolSize(int poolSize) {
        this.setPoolSize(poolSize);
        return this;
    }
}

