/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.service.impl;

import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.ow2.jonas.camel.service.api.ICamelService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CamelContextServiceFactory
implements ServiceFactory {
    private final Log logger = LogFactory.getLog(CamelContextServiceFactory.class);
    private ICamelService camelService = null;
    private Map<Bundle, String> camelBundleContexts = new HashMap<Bundle, String>();

    public synchronized Object getService(Bundle bundle, ServiceRegistration registration) {
        if (!this.camelBundleContexts.containsKey(bundle)) {
            try {
                this.camelBundleContexts.put(bundle, this.camelService.startNewContext());
            }
            catch (Exception e) {
                this.logger.error((Object)"Camel context creation failed for bundle {0}.", new Object[]{bundle});
            }
        }
        String contextName = this.camelBundleContexts.get(bundle);
        return this.camelService.getCamelContext(contextName);
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object camelContext) {
        String contextName = this.camelBundleContexts.get(bundle);
        try {
            this.camelService.stop(contextName);
            this.logger.debug((Object)"The camel context {0} has been stopped.", new Object[]{contextName});
        }
        catch (Exception e) {
            this.logger.warn((Object)"Cannot stop the camel context {0}.", new Object[]{contextName, e});
        }
        this.camelBundleContexts.remove(bundle);
    }

    public void setCamelService(ICamelService camelService) {
        this.camelService = camelService;
    }
}

