/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.Connection;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.Processor;
import org.apache.camel.SuspendableService;
import org.apache.camel.component.jms.EndpointMessageListener;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;

public class JmsConsumer
extends DefaultConsumer
implements SuspendableService {
    private AbstractMessageListenerContainer listenerContainer;
    private EndpointMessageListener messageListener;
    private volatile boolean initialized;

    public JmsConsumer(JmsEndpoint endpoint, Processor processor, AbstractMessageListenerContainer listenerContainer) {
        super((Endpoint)endpoint, processor);
        this.listenerContainer = listenerContainer;
        this.listenerContainer.setMessageListener((Object)this.getEndpointMessageListener());
    }

    public JmsEndpoint getEndpoint() {
        return (JmsEndpoint)super.getEndpoint();
    }

    public AbstractMessageListenerContainer getListenerContainer() {
        if (this.listenerContainer == null) {
            this.createMessageListenerContainer();
        }
        return this.listenerContainer;
    }

    public EndpointMessageListener getEndpointMessageListener() {
        if (this.messageListener == null) {
            this.createMessageListener(this.getEndpoint(), this.getProcessor());
        }
        return this.messageListener;
    }

    protected void createMessageListener(JmsEndpoint endpoint, Processor processor) {
        this.messageListener = new EndpointMessageListener(endpoint, processor);
        this.messageListener.setBinding(endpoint.getBinding());
    }

    protected void createMessageListenerContainer() {
        this.listenerContainer = this.getEndpoint().createMessageListenerContainer();
        this.getEndpoint().configureListenerContainer(this.listenerContainer);
        this.listenerContainer.setMessageListener((Object)this.getEndpointMessageListener());
    }

    public void startListenerContainer() {
        this.listenerContainer.start();
    }

    protected void testConnectionOnStartup() throws FailedToCreateConsumerException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Testing JMS Connection on startup for destination: " + this.getDestinationName()));
            }
            Connection con = this.listenerContainer.getConnectionFactory().createConnection();
            JmsUtils.closeConnection((Connection)con);
            this.log.info((Object)("Successfully tested JMS Connection on startup for destination: " + this.getDestinationName()));
        }
        catch (Exception e) {
            String msg = "Cannot get JMS Connection on startup for destination " + this.getDestinationName();
            throw new FailedToCreateConsumerException((Endpoint)this.getEndpoint(), msg, (Throwable)e);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.listenerContainer == null) {
            this.createMessageListenerContainer();
        }
        this.listenerContainer.afterPropertiesSet();
        if (this.initialized || this.getEndpoint().isAutoStartup()) {
            if (this.getEndpoint().isTestConnectionOnStartup()) {
                this.testConnectionOnStartup();
            }
            this.startListenerContainer();
        }
        this.initialized = true;
    }

    protected void doStop() throws Exception {
        this.listenerContainer.stop();
        this.listenerContainer.destroy();
        this.listenerContainer = null;
        this.messageListener = null;
        super.doStop();
    }

    protected void doSuspend() throws Exception {
        if (this.listenerContainer != null) {
            this.listenerContainer.stop();
        }
    }

    protected void doResume() throws Exception {
        if (this.listenerContainer != null) {
            this.startListenerContainer();
        }
    }

    private String getDestinationName() {
        if (this.listenerContainer.getDestination() != null) {
            return this.listenerContainer.getDestination().toString();
        }
        return this.listenerContainer.getDestinationName();
    }
}

