/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.processor.ProcessorExchangePair;
import org.apache.camel.processor.Traceable;
import org.apache.camel.processor.UnitOfWorkProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.TimeoutAwareAggregationStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TracedRouteNodes;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.concurrent.AtomicException;
import org.apache.camel.util.concurrent.AtomicExchange;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;
import org.apache.camel.util.concurrent.SubmitOrderedCompletionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastProcessor
extends ServiceSupport
implements AsyncProcessor,
Navigate<Processor>,
Traceable {
    private static final transient Log LOG = LogFactory.getLog(MulticastProcessor.class);
    private final CamelContext camelContext;
    private Collection<Processor> processors;
    private final AggregationStrategy aggregationStrategy;
    private final boolean parallelProcessing;
    private final boolean streaming;
    private final boolean stopOnException;
    private final ExecutorService executorService;
    private ExecutorService aggregateExecutorService;
    private final long timeout;
    private final ConcurrentMap<PreparedErrorHandler, Processor> errorHandlers = new ConcurrentHashMap<PreparedErrorHandler, Processor>();

    public MulticastProcessor(CamelContext camelContext, Collection<Processor> processors) {
        this(camelContext, processors, null);
    }

    public MulticastProcessor(CamelContext camelContext, Collection<Processor> processors, AggregationStrategy aggregationStrategy) {
        this(camelContext, processors, aggregationStrategy, false, null, false, false, 0L);
    }

    public MulticastProcessor(CamelContext camelContext, Collection<Processor> processors, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean streaming, boolean stopOnException, long timeout) {
        ObjectHelper.notNull(camelContext, "camelContext");
        this.camelContext = camelContext;
        this.processors = processors;
        this.aggregationStrategy = aggregationStrategy;
        this.executorService = executorService;
        this.streaming = streaming;
        this.stopOnException = stopOnException;
        this.parallelProcessing = parallelProcessing || executorService != null;
        this.timeout = timeout;
    }

    public String toString() {
        return "Multicast[" + this.getProcessors() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "multicast";
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        AtomicExchange result = new AtomicExchange();
        boolean exhaust = false;
        try {
            boolean sync = true;
            Iterable<ProcessorExchangePair> pairs = this.createProcessorExchangePairs(exchange);
            exhaust = true;
            if (this.isParallelProcessing()) {
                ObjectHelper.notNull(this.executorService, "executorService", this);
                this.doProcessParallel(exchange, result, pairs, this.isStreaming(), callback);
            } else {
                sync = this.doProcessSequential(exchange, result, pairs, callback);
            }
            if (!sync) {
                return false;
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
            this.doDone(exchange, null, callback, true, exhaust);
            return true;
        }
        Exchange subExchange = result.get() != null ? (Exchange)result.get() : null;
        this.doDone(exchange, subExchange, callback, true, exhaust);
        return true;
    }

    protected void doProcessParallel(Exchange original, AtomicExchange result, Iterable<ProcessorExchangePair> pairs, boolean streaming, AsyncCallback callback) throws Exception {
        ObjectHelper.notNull(this.executorService, "ExecutorService", this);
        ObjectHelper.notNull(this.aggregateExecutorService, "AggregateExecutorService", this);
        CompletionService completion = streaming ? new ExecutorCompletionService(this.executorService) : new SubmitOrderedCompletionService(this.executorService);
        final AtomicBoolean running = new AtomicBoolean(true);
        AtomicInteger total = new AtomicInteger(0);
        AtomicBoolean allTasksSubmitted = new AtomicBoolean();
        CountDownLatch aggregationOnTheFlyDone = new CountDownLatch(1);
        AtomicException executionException = new AtomicException();
        Iterator<ProcessorExchangePair> it = pairs.iterator();
        if (it.hasNext()) {
            AggregateOnTheFlyTask task = new AggregateOnTheFlyTask(result, original, total, completion, running, aggregationOnTheFlyDone, allTasksSubmitted, executionException);
            this.aggregateExecutorService.submit(task);
        }
        LOG.trace((Object)"Starting to submit parallel tasks");
        while (it.hasNext()) {
            final ProcessorExchangePair pair = it.next();
            final Exchange subExchange = pair.getExchange();
            this.updateNewExchange(subExchange, total.intValue(), pairs, it);
            completion.submit(new Callable<Exchange>(){

                @Override
                public Exchange call() throws Exception {
                    if (!running.get()) {
                        return subExchange;
                    }
                    try {
                        MulticastProcessor.this.doProcessParallel(pair);
                    }
                    catch (Throwable e) {
                        subExchange.setException(e);
                    }
                    Integer number = MulticastProcessor.this.getExchangeIndex(subExchange);
                    boolean continueProcessing = PipelineHelper.continueProcessing(subExchange, "Parallel processing failed for number " + number, LOG);
                    if (MulticastProcessor.this.stopOnException && !continueProcessing) {
                        running.set(false);
                        if (subExchange.getException() != null) {
                            throw new CamelExchangeException("Parallel processing failed for number " + number, subExchange, subExchange.getException());
                        }
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Parallel processing complete for exchange: " + subExchange));
                    }
                    return subExchange;
                }
            });
            total.incrementAndGet();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Signaling that all " + total.get() + " tasks has been submitted."));
        }
        allTasksSubmitted.set(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Waiting for on-the-fly aggregation to complete aggregating " + total.get() + " responses."));
        }
        aggregationOnTheFlyDone.await();
        if (executionException.get() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Parallel processing failed due " + ((Exception)executionException.get()).getMessage()));
            }
            throw (Exception)executionException.get();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Done parallel processing " + total + " exchanges"));
        }
    }

    protected boolean doProcessSequential(Exchange original, AtomicExchange result, Iterable<ProcessorExchangePair> pairs, AsyncCallback callback) throws Exception {
        AtomicInteger total = new AtomicInteger();
        Iterator<ProcessorExchangePair> it = pairs.iterator();
        while (it.hasNext()) {
            ProcessorExchangePair pair = it.next();
            Exchange subExchange = pair.getExchange();
            this.updateNewExchange(subExchange, total.get(), pairs, it);
            boolean sync = this.doProcessSequential(original, result, pairs, it, pair, callback, total);
            if (!sync) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Processing exchangeId: " + pair.getExchange().getExchangeId() + " is continued being processed asynchronously"));
                }
                return false;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Processing exchangeId: " + pair.getExchange().getExchangeId() + " is continued being processed synchronously"));
            }
            boolean continueProcessing = PipelineHelper.continueProcessing(subExchange, "Sequential processing failed for number " + total.get(), LOG);
            if (this.stopOnException && !continueProcessing) {
                if (subExchange.getException() != null) {
                    throw new CamelExchangeException("Sequential processing failed for number " + total.get(), subExchange, subExchange.getException());
                }
                result.set(subExchange);
                return true;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Sequential processing complete for number " + total + " exchange: " + subExchange));
            }
            this.doAggregate(this.getAggregationStrategy(subExchange), result, subExchange);
            total.incrementAndGet();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Done sequential processing " + total + " exchanges"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doProcessSequential(final Exchange original, final AtomicExchange result, final Iterable<ProcessorExchangePair> pairs, final Iterator<ProcessorExchangePair> it, final ProcessorExchangePair pair, final AsyncCallback callback, final AtomicInteger total) {
        boolean sync;
        block7: {
            Endpoint endpoint2;
            long timeTaken2;
            sync = true;
            final Exchange exchange = pair.getExchange();
            Processor processor = pair.getProcessor();
            Producer producer = pair.getProducer();
            TracedRouteNodes traced = exchange.getUnitOfWork() != null ? exchange.getUnitOfWork().getTracedRouteNodes() : null;
            StopWatch watch = null;
            if (producer != null) {
                watch = new StopWatch();
            }
            try {
                if (traced != null) {
                    traced.pushBlock();
                }
                AsyncProcessor async = AsyncProcessorTypeConverter.convert(processor);
                pair.begin();
                sync = AsyncProcessorHelper.process(async, exchange, new AsyncCallback(){

                    public void done(boolean doneSync) {
                        pair.done();
                        if (doneSync) {
                            return;
                        }
                        Exchange subExchange = exchange;
                        boolean continueProcessing = PipelineHelper.continueProcessing(subExchange, "Sequential processing failed for number " + total.get(), LOG);
                        if (MulticastProcessor.this.stopOnException && !continueProcessing) {
                            if (subExchange.getException() != null) {
                                subExchange.setException(new CamelExchangeException("Sequential processing failed for number " + total, subExchange, subExchange.getException()));
                            } else {
                                result.set(subExchange);
                            }
                            MulticastProcessor.this.doDone(original, subExchange, callback, false, true);
                            return;
                        }
                        try {
                            MulticastProcessor.this.doAggregate(MulticastProcessor.this.getAggregationStrategy(subExchange), result, subExchange);
                        }
                        catch (Throwable e) {
                            subExchange.setException(new CamelExchangeException("Sequential processing failed for number " + total, subExchange, e));
                            MulticastProcessor.this.doDone(original, subExchange, callback, false, true);
                            return;
                        }
                        total.incrementAndGet();
                        while (it.hasNext()) {
                            ProcessorExchangePair pair2 = (ProcessorExchangePair)it.next();
                            subExchange = pair2.getExchange();
                            MulticastProcessor.this.updateNewExchange(subExchange, total.get(), pairs, it);
                            boolean sync = MulticastProcessor.this.doProcessSequential(original, result, pairs, it, pair2, callback, total);
                            if (!sync) {
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace((Object)("Processing exchangeId: " + original.getExchangeId() + " is continued being processed asynchronously"));
                                }
                                return;
                            }
                            continueProcessing = PipelineHelper.continueProcessing(subExchange, "Sequential processing failed for number " + total.get(), LOG);
                            if (MulticastProcessor.this.stopOnException && !continueProcessing) {
                                if (subExchange.getException() != null) {
                                    subExchange.setException(new CamelExchangeException("Sequential processing failed for number " + total, subExchange, subExchange.getException()));
                                } else {
                                    result.set(subExchange);
                                }
                                MulticastProcessor.this.doDone(original, subExchange, callback, false, true);
                                return;
                            }
                            try {
                                MulticastProcessor.this.doAggregate(MulticastProcessor.this.getAggregationStrategy(subExchange), result, subExchange);
                            }
                            catch (Throwable e) {
                                subExchange.setException(new CamelExchangeException("Sequential processing failed for number " + total, subExchange, e));
                                MulticastProcessor.this.doDone(original, subExchange, callback, false, true);
                                return;
                            }
                            total.incrementAndGet();
                        }
                        subExchange = result.get() != null ? (Exchange)result.get() : null;
                        MulticastProcessor.this.doDone(original, subExchange, callback, false, true);
                    }
                });
                Object var16_15 = null;
                if (traced != null) {
                    traced.popBlock();
                }
                if (producer == null) break block7;
                timeTaken2 = watch.stop();
                endpoint2 = producer.getEndpoint();
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                if (traced != null) {
                    traced.popBlock();
                }
                if (producer != null) {
                    long timeTaken2 = watch.stop();
                    Endpoint endpoint2 = producer.getEndpoint();
                    EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint2, timeTaken2);
                }
                throw throwable;
            }
            EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint2, timeTaken2);
            {
            }
        }
        return sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcessParallel(ProcessorExchangePair pair) throws Exception {
        block7: {
            Endpoint endpoint2;
            long timeTaken2;
            Exchange exchange = pair.getExchange();
            Processor processor = pair.getProcessor();
            Producer producer = pair.getProducer();
            TracedRouteNodes traced = exchange.getUnitOfWork() != null ? exchange.getUnitOfWork().getTracedRouteNodes() : null;
            StopWatch watch = null;
            if (producer != null) {
                watch = new StopWatch();
            }
            try {
                if (traced != null) {
                    traced.pushBlock();
                }
                AsyncProcessor async = AsyncProcessorTypeConverter.convert(processor);
                pair.begin();
                AsyncProcessorHelper.process(async, exchange);
                Object var9_8 = null;
                pair.done();
                if (traced != null) {
                    traced.popBlock();
                }
                if (producer == null) break block7;
                timeTaken2 = watch.stop();
                endpoint2 = producer.getEndpoint();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                pair.done();
                if (traced != null) {
                    traced.popBlock();
                }
                if (producer != null) {
                    long timeTaken2 = watch.stop();
                    Endpoint endpoint2 = producer.getEndpoint();
                    EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint2, timeTaken2);
                }
                throw throwable;
            }
            EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint2, timeTaken2);
            {
            }
        }
    }

    protected void doDone(Exchange original, Exchange subExchange, AsyncCallback callback, boolean doneSync, boolean exhaust) {
        this.removeAggregationStrategyFromExchange(original);
        if (original.getException() != null) {
            original.setProperty("CamelRedeliveryExhausted", exhaust);
        }
        if (subExchange != null) {
            ExchangeHelper.copyResults(original, subExchange);
        }
        callback.done(doneSync);
    }

    protected synchronized void doAggregate(AggregationStrategy strategy, AtomicExchange result, Exchange exchange) {
        if (strategy != null) {
            Exchange oldExchange = (Exchange)result.get();
            ExchangeHelper.prepareAggregation(oldExchange, exchange);
            result.set(strategy.aggregate(oldExchange, exchange));
        }
    }

    protected void updateNewExchange(Exchange exchange, int index, Iterable<ProcessorExchangePair> allPairs, Iterator<ProcessorExchangePair> it) {
        exchange.setProperty("CamelMulticastIndex", index);
        if (it.hasNext()) {
            exchange.setProperty("CamelMulticastComplete", Boolean.FALSE);
        } else {
            exchange.setProperty("CamelMulticastComplete", Boolean.TRUE);
        }
    }

    protected Integer getExchangeIndex(Exchange exchange) {
        return exchange.getProperty("CamelMulticastIndex", Integer.class);
    }

    protected Iterable<ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) throws Exception {
        ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>(this.processors.size());
        int index = 0;
        for (Processor processor : this.processors) {
            Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, false);
            RouteContext routeContext = exchange.getUnitOfWork() != null ? exchange.getUnitOfWork().getRouteContext() : null;
            result.add(this.createProcessorExchangePair(index++, processor, copy, routeContext));
        }
        return result;
    }

    protected ProcessorExchangePair createProcessorExchangePair(int index, Processor processor, Exchange exchange, RouteContext routeContext) {
        Processor prepared = processor;
        MulticastProcessor.setToEndpoint(exchange, prepared);
        prepared = this.createErrorHandler(routeContext, prepared);
        return new DefaultProcessorExchangePair(index, processor, prepared, exchange);
    }

    protected Processor createErrorHandler(RouteContext routeContext, Processor processor) {
        Processor answer;
        if (routeContext != null) {
            PreparedErrorHandler key = new PreparedErrorHandler(routeContext, processor);
            answer = (Processor)this.errorHandlers.get(key);
            if (answer != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Using existing error handler for: " + processor));
                }
                return answer;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Creating error handler for: " + processor));
            }
            ErrorHandlerBuilder builder = routeContext.getRoute().getErrorHandlerBuilder();
            try {
                processor = builder.createErrorHandler(routeContext, processor);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
            answer = new UnitOfWorkProcessor(processor);
            this.errorHandlers.putIfAbsent(key, answer);
        } else {
            answer = new UnitOfWorkProcessor(processor);
        }
        return answer;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.isParallelProcessing() && this.executorService == null) {
            throw new IllegalArgumentException("ParallelProcessing is enabled but ExecutorService has not been set");
        }
        if (this.timeout > 0L && !this.isParallelProcessing()) {
            throw new IllegalArgumentException("Timeout is used but ParallelProcessing has not been enabled");
        }
        if (this.isParallelProcessing() && this.aggregateExecutorService == null) {
            String name = this.getClass().getSimpleName() + "-AggregateTask";
            this.aggregateExecutorService = this.camelContext.getExecutorServiceStrategy().newThreadPool(this, name, 1, Integer.MAX_VALUE);
        }
        ServiceHelper.startServices(this.processors);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.processors);
        this.errorHandlers.clear();
    }

    protected static void setToEndpoint(Exchange exchange, Processor processor) {
        if (processor instanceof Producer) {
            Producer producer = (Producer)processor;
            exchange.setProperty("CamelToEndpoint", producer.getEndpoint().getEndpointUri());
        }
    }

    protected AggregationStrategy getAggregationStrategy(Exchange exchange) {
        Map property;
        Map map;
        AggregationStrategy answer = null;
        if (exchange != null && (map = CastUtils.cast(property = exchange.getProperty("CamelAggregationStrategy", Map.class))) != null) {
            answer = (AggregationStrategy)map.get(this);
        }
        if (answer == null) {
            answer = this.getAggregationStrategy();
        }
        return answer;
    }

    protected void setAggregationStrategyOnExchange(Exchange exchange, AggregationStrategy aggregationStrategy) {
        Map property = exchange.getProperty("CamelAggregationStrategy", Map.class);
        Map map = CastUtils.cast(property);
        if (map == null) {
            map = new HashMap();
        }
        map.put(this, aggregationStrategy);
        exchange.setProperty("CamelAggregationStrategy", map);
    }

    protected void removeAggregationStrategyFromExchange(Exchange exchange) {
        Map property = exchange.getProperty("CamelAggregationStrategy", Map.class);
        Map map = CastUtils.cast(property);
        if (map == null) {
            return;
        }
        map.remove(this);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isStopOnException() {
        return this.stopOnException;
    }

    public Collection<Processor> getProcessors() {
        return this.processors;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        return new ArrayList<Processor>(this.processors);
    }

    @Override
    public boolean hasNext() {
        return this.processors != null && !this.processors.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AggregateOnTheFlyTask
    implements Runnable {
        private final AtomicExchange result;
        private final Exchange original;
        private final AtomicInteger total;
        private final CompletionService<Exchange> completion;
        private final AtomicBoolean running;
        private final CountDownLatch aggregationOnTheFlyDone;
        private final AtomicBoolean allTasksSubmitted;
        private final AtomicException executionException;

        private AggregateOnTheFlyTask(AtomicExchange result, Exchange original, AtomicInteger total, CompletionService<Exchange> completion, AtomicBoolean running, CountDownLatch aggregationOnTheFlyDone, AtomicBoolean allTasksSubmitted, AtomicException executionException) {
            this.result = result;
            this.original = original;
            this.total = total;
            this.completion = completion;
            this.running = running;
            this.aggregationOnTheFlyDone = aggregationOnTheFlyDone;
            this.allTasksSubmitted = allTasksSubmitted;
            this.executionException = executionException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            LOG.trace((Object)"Aggregate on the fly task +++ started +++");
            try {
                try {
                    this.aggregateOnTheFly();
                }
                catch (Throwable e) {
                    if (e instanceof Exception) {
                        this.executionException.set((Exception)e);
                    } else {
                        this.executionException.set(ObjectHelper.wrapRuntimeCamelException(e));
                    }
                    Object var3_2 = null;
                    LOG.debug((Object)"Signaling we are done aggregating on the fly");
                    LOG.trace((Object)"Aggregate on the fly task +++ done +++");
                    this.aggregationOnTheFlyDone.countDown();
                    return;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                LOG.debug((Object)"Signaling we are done aggregating on the fly");
                LOG.trace((Object)"Aggregate on the fly task +++ done +++");
                this.aggregationOnTheFlyDone.countDown();
                throw throwable;
            }
            LOG.debug((Object)"Signaling we are done aggregating on the fly");
            LOG.trace((Object)"Aggregate on the fly task +++ done +++");
            this.aggregationOnTheFlyDone.countDown();
        }

        private void aggregateOnTheFly() throws InterruptedException, ExecutionException {
            boolean timedOut = false;
            boolean stoppedOnException = false;
            StopWatch watch = new StopWatch();
            int aggregated = 0;
            boolean done = false;
            while (!done) {
                Future<Exchange> future;
                if (this.allTasksSubmitted.get() && aggregated >= this.total.get()) {
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug((Object)("Done aggregating " + aggregated + " exchanges on the fly."));
                    break;
                }
                if (timedOut) {
                    future = this.completion.poll();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Polled completion task #" + aggregated + " after timeout to grab already completed tasks: " + future));
                    }
                } else if (MulticastProcessor.this.timeout > 0L) {
                    long left = MulticastProcessor.this.timeout - watch.taken();
                    if (left < 0L) {
                        left = 0L;
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Polling completion task #" + aggregated + " using timeout " + left + " millis."));
                    }
                    future = this.completion.poll(left, TimeUnit.MILLISECONDS);
                } else {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Polling completion task #" + aggregated));
                    }
                    if ((future = this.completion.poll(1L, TimeUnit.SECONDS)) == null) continue;
                }
                if (future == null && timedOut) break;
                if (future == null) {
                    AggregationStrategy strategy = MulticastProcessor.this.getAggregationStrategy(null);
                    if (strategy instanceof TimeoutAwareAggregationStrategy) {
                        Exchange oldExchange = (Exchange)this.result.get();
                        if (oldExchange == null) {
                            oldExchange = this.original;
                        }
                        ((TimeoutAwareAggregationStrategy)strategy).timeout(oldExchange, aggregated, this.total.intValue(), MulticastProcessor.this.timeout);
                    } else {
                        LOG.warn((Object)("Parallel processing timed out after " + MulticastProcessor.this.timeout + " millis for number " + aggregated + ". This task will be cancelled and will not be aggregated."));
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Timeout occurred after " + MulticastProcessor.this.timeout + " millis for number " + aggregated + " task."));
                    }
                    timedOut = true;
                    ExecutorServiceHelper.timeoutTask(this.completion);
                } else {
                    Exchange subExchange = future.get();
                    Integer number = MulticastProcessor.this.getExchangeIndex(subExchange);
                    boolean continueProcessing = PipelineHelper.continueProcessing(subExchange, "Parallel processing failed for number " + number, LOG);
                    if (MulticastProcessor.this.stopOnException && !continueProcessing) {
                        this.result.set(subExchange);
                        stoppedOnException = true;
                        break;
                    }
                    AggregationStrategy strategy = MulticastProcessor.this.getAggregationStrategy(subExchange);
                    MulticastProcessor.this.doAggregate(strategy, this.result, subExchange);
                }
                ++aggregated;
            }
            if (timedOut || stoppedOnException) {
                if (timedOut && LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Cancelling tasks due timeout after " + MulticastProcessor.this.timeout + " millis."));
                }
                if (stoppedOnException && LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Cancelling tasks due stopOnException.");
                }
                this.running.set(false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class PreparedErrorHandler
    extends KeyValueHolder<RouteContext, Processor> {
        public PreparedErrorHandler(RouteContext key, Processor value) {
            super(key, value);
        }
    }

    static final class DefaultProcessorExchangePair
    implements ProcessorExchangePair {
        private final int index;
        private final Processor processor;
        private final Processor prepared;
        private final Exchange exchange;

        private DefaultProcessorExchangePair(int index, Processor processor, Processor prepared, Exchange exchange) {
            this.index = index;
            this.processor = processor;
            this.prepared = prepared;
            this.exchange = exchange;
        }

        public int getIndex() {
            return this.index;
        }

        public Exchange getExchange() {
            return this.exchange;
        }

        public Producer getProducer() {
            if (this.processor instanceof Producer) {
                return (Producer)this.processor;
            }
            return null;
        }

        public Processor getProcessor() {
            return this.prepared;
        }

        public void begin() {
        }

        public void done() {
        }
    }
}

