/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.DelayProcessorSupport;
import org.apache.camel.processor.interceptor.Delayer;

public class DelayInterceptor
extends DelayProcessorSupport {
    private final ProcessorDefinition<?> node;
    private Delayer delayer;

    public DelayInterceptor(CamelContext camelContext, ProcessorDefinition<?> node, Processor target, Delayer delayer) {
        super(camelContext, target);
        this.node = node;
        this.delayer = delayer;
    }

    @Override
    public String toString() {
        return "DelayInterceptor[delay: " + this.delayer.getDelay() + " on: " + this.node + "]";
    }

    @Override
    public long calculateDelay(Exchange exchange) {
        if (this.delayer.isEnabled()) {
            return this.delayer.getDelay();
        }
        return 0L;
    }
}

