/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntrospectionSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(IntrospectionSupport.class);
    private static final Pattern GETTER_PATTERN = Pattern.compile("(get|is)[A-Z].*");
    private static final Pattern SETTER_PATTERN = Pattern.compile("set[A-Z].*");
    private static final List<Method> EXCLUDED_METHODS = new ArrayList<Method>();
    private static final Set<Class> PRIMITIVE_CLASSES;

    private IntrospectionSupport() {
    }

    public static boolean isGetter(Method method) {
        String name = method.getName();
        Class<?> type = method.getReturnType();
        Class<?>[] params = method.getParameterTypes();
        if (!GETTER_PATTERN.matcher(name).matches()) {
            return false;
        }
        if (name.startsWith("is")) {
            return params.length == 0 && type.getSimpleName().equalsIgnoreCase("boolean");
        }
        return params.length == 0 && !type.equals(Void.TYPE);
    }

    public static String getGetterShorthandName(Method method) {
        if (!IntrospectionSupport.isGetter(method)) {
            return method.getName();
        }
        String name = method.getName();
        if (name.startsWith("get")) {
            name = name.substring(3);
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        } else if (name.startsWith("is")) {
            name = name.substring(2);
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        }
        return name;
    }

    public static String getSetterShorthandName(Method method) {
        if (!IntrospectionSupport.isSetter(method)) {
            return method.getName();
        }
        String name = method.getName();
        if (name.startsWith("set")) {
            name = name.substring(3);
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        }
        return name;
    }

    public static boolean isSetter(Method method, boolean allowBuilderPattern) {
        String name = method.getName();
        Class<?> type = method.getReturnType();
        Class<?>[] params = method.getParameterTypes();
        if (!SETTER_PATTERN.matcher(name).matches()) {
            return false;
        }
        return params.length == 1 && (type.equals(Void.TYPE) || allowBuilderPattern && method.getDeclaringClass().isAssignableFrom(type));
    }

    public static boolean isSetter(Method method) {
        return IntrospectionSupport.isSetter(method, false);
    }

    public static boolean getProperties(Object target, Map<String, Object> properties, String optionPrefix) {
        Method[] methods;
        ObjectHelper.notNull(target, "target");
        ObjectHelper.notNull(properties, "properties");
        boolean rc = false;
        if (optionPrefix == null) {
            optionPrefix = "";
        }
        Class<?> clazz = target.getClass();
        for (Method method : methods = clazz.getMethods()) {
            if (EXCLUDED_METHODS.contains(method)) continue;
            try {
                if (!IntrospectionSupport.isGetter(method) || !IntrospectionSupport.hasSetter(target, method)) continue;
                method.setAccessible(true);
                Object value = method.invoke(target, new Object[0]);
                String name = IntrospectionSupport.getGetterShorthandName(method);
                properties.put(optionPrefix + name, value);
                rc = true;
            }
            catch (Exception e) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Error invoking getter method " + method + ". This exception is ignored.", (Throwable)e);
            }
        }
        return rc;
    }

    public static boolean hasSetter(Object target, Method getter) {
        Method[] methods;
        String name = IntrospectionSupport.getGetterShorthandName(getter);
        Class<?> clazz = target.getClass();
        for (Method method : methods = clazz.getMethods()) {
            if (EXCLUDED_METHODS.contains(method) || !IntrospectionSupport.isSetter(method) || !name.equals(IntrospectionSupport.getSetterShorthandName(method))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasProperties(Map<String, Object> properties, String optionPrefix) {
        ObjectHelper.notNull(properties, "properties");
        if (ObjectHelper.isNotEmpty(optionPrefix)) {
            for (String o : properties.keySet()) {
                String name = o;
                if (!name.startsWith(optionPrefix)) continue;
                return true;
            }
            return false;
        }
        return !properties.isEmpty();
    }

    public static Object getProperty(Object target, String property) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ObjectHelper.notNull(target, "target");
        ObjectHelper.notNull(property, "property");
        property = property.substring(0, 1).toUpperCase(Locale.ENGLISH) + property.substring(1);
        Class<?> clazz = target.getClass();
        Method method = IntrospectionSupport.getPropertyGetter(clazz, property);
        return method.invoke(target, new Object[0]);
    }

    public static Method getPropertyGetter(Class<?> type, String propertyName) throws NoSuchMethodException {
        if (IntrospectionSupport.isPropertyIsGetter(type, propertyName)) {
            return type.getMethod("is" + ObjectHelper.capitalize(propertyName), new Class[0]);
        }
        return type.getMethod("get" + ObjectHelper.capitalize(propertyName), new Class[0]);
    }

    public static Method getPropertySetter(Class<?> type, String propertyName) throws NoSuchMethodException {
        String name = "set" + ObjectHelper.capitalize(propertyName);
        for (Method method : type.getMethods()) {
            if (!IntrospectionSupport.isSetter(method) || !method.getName().equals(name)) continue;
            return method;
        }
        throw new NoSuchMethodException(type.getCanonicalName() + "." + name);
    }

    public static boolean isPropertyIsGetter(Class<?> type, String propertyName) {
        try {
            Method method = type.getMethod("is" + ObjectHelper.capitalize(propertyName), new Class[0]);
            if (method != null) {
                return method.getReturnType().isAssignableFrom(Boolean.TYPE) || method.getReturnType().isAssignableFrom(Boolean.class);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    public static boolean setProperties(Object target, Map<String, Object> properties, String optionPrefix, boolean allowBuilderPattern) throws Exception {
        ObjectHelper.notNull(target, "target");
        ObjectHelper.notNull(properties, "properties");
        boolean rc = false;
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey().toString();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = properties.get(name);
            if (!IntrospectionSupport.setProperty(target, name = name.substring(optionPrefix.length()), value, allowBuilderPattern)) continue;
            it.remove();
            rc = true;
        }
        return rc;
    }

    public static boolean setProperties(Object target, Map<String, Object> properties, String optionPrefix) throws Exception {
        return IntrospectionSupport.setProperties(target, properties, optionPrefix, false);
    }

    public static Map<String, Object> extractProperties(Map<String, Object> properties, String optionPrefix) {
        ObjectHelper.notNull(properties, "properties");
        LinkedHashMap<String, Object> rc = new LinkedHashMap<String, Object>(properties.size());
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = properties.get(name);
            name = name.substring(optionPrefix.length());
            rc.put(name, value);
            it.remove();
        }
        return rc;
    }

    public static boolean setProperties(TypeConverter typeConverter, Object target, Map<String, Object> properties) throws Exception {
        ObjectHelper.notNull(target, "target");
        ObjectHelper.notNull(properties, "properties");
        boolean rc = false;
        Iterator<Map.Entry<String, Object>> iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            if (!IntrospectionSupport.setProperty(typeConverter, target, entry.getKey(), entry.getValue())) continue;
            iter.remove();
            rc = true;
        }
        return rc;
    }

    public static boolean setProperties(Object target, Map<String, Object> properties) throws Exception {
        return IntrospectionSupport.setProperties(null, target, properties);
    }

    public static boolean setProperty(CamelContext context, TypeConverter typeConverter, Object target, String name, Object value, String refName, boolean allowBuilderPattern) throws Exception {
        Class<?> clazz = target.getClass();
        Collection<Method> setters = context != null && refName != null && value == null ? IntrospectionSupport.findSetterMethodsOrderedByParameterType(clazz, name, allowBuilderPattern) : IntrospectionSupport.findSetterMethods(clazz, name, value, allowBuilderPattern);
        if (setters.isEmpty()) {
            return false;
        }
        Exception typeConversionFailed = null;
        for (Method setter : setters) {
            Class<?> parameterType = setter.getParameterTypes()[0];
            Object ref = value;
            if (context != null && refName != null && ref == null && (ref = CamelContextHelper.lookup(context, refName.replaceAll("#", ""), parameterType)) == null) continue;
            try {
                try {
                    if (value == null || parameterType.isAssignableFrom(ref.getClass())) {
                        setter.setAccessible(true);
                        setter.invoke(target, ref);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Configured property: {} on bean: {} with value: {}", new Object[]{name, target, ref});
                        }
                        return true;
                    }
                    Object convertedValue = IntrospectionSupport.convert(typeConverter, parameterType, ref);
                    setter.setAccessible(true);
                    setter.invoke(target, convertedValue);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Configured property: {} on bean: {} with value: {}", new Object[]{name, target, ref});
                    }
                    return true;
                }
                catch (InvocationTargetException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw exception;
                    }
                    Error error = (Error)throwable;
                    throw error;
                }
            }
            catch (SecurityException e) {
                typeConversionFailed = e;
            }
            catch (NoTypeConversionAvailableException e) {
                typeConversionFailed = e;
            }
            catch (IllegalArgumentException e) {
                typeConversionFailed = e;
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Setter \"{}\" with parameter type \"{}\" could not be used for type conversions of {}", new Object[]{setter, parameterType, ref});
        }
        if (typeConversionFailed != null) {
            throw new IllegalArgumentException("Could not find a suitable setter for property: " + name + " as there isn't a setter method with same type: " + (value != null ? value.getClass().getCanonicalName() : "[null]") + " nor type conversion possible: " + typeConversionFailed.getMessage());
        }
        return false;
    }

    public static boolean setProperty(TypeConverter typeConverter, Object target, String name, Object value) throws Exception {
        return IntrospectionSupport.setProperty(null, typeConverter, target, name, value, null, true);
    }

    public static boolean setProperty(Object target, String name, Object value, boolean allowBuilderPattern) throws Exception {
        return IntrospectionSupport.setProperty(null, null, target, name, value, null, allowBuilderPattern);
    }

    public static boolean setProperty(Object target, String name, Object value) throws Exception {
        return IntrospectionSupport.setProperty(target, name, value, true);
    }

    private static Object convert(TypeConverter typeConverter, Class<?> type, Object value) throws URISyntaxException, NoTypeConversionAvailableException {
        if (typeConverter != null) {
            return typeConverter.mandatoryConvertTo(type, value);
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            editor.setAsText(value.toString());
            return editor.getValue();
        }
        if (type == URI.class) {
            return new URI(value.toString());
        }
        return null;
    }

    public static Set<Method> findSetterMethods(Class<?> clazz, String name, boolean allowBuilderPattern) {
        LinkedHashSet<Method> candidates = new LinkedHashSet<Method>();
        name = "set" + ObjectHelper.capitalize(name);
        while (clazz != Object.class) {
            Method[] methods;
            Method objectSetMethod = null;
            for (Method method : methods = clazz.getMethods()) {
                if (!method.getName().equals(name) || !IntrospectionSupport.isSetter(method, allowBuilderPattern)) continue;
                Class<?>[] params = method.getParameterTypes();
                if (params[0].equals(Object.class)) {
                    objectSetMethod = method;
                    continue;
                }
                candidates.add(method);
            }
            if (objectSetMethod != null) {
                candidates.add(objectSetMethod);
            }
            clazz = clazz.getSuperclass();
        }
        return candidates;
    }

    private static Set<Method> findSetterMethods(Class<?> clazz, String name, Object value, boolean allowBuilderPattern) {
        Set<Method> candidates = IntrospectionSupport.findSetterMethods(clazz, name, allowBuilderPattern);
        if (candidates.isEmpty()) {
            return candidates;
        }
        if (candidates.size() == 1) {
            return candidates;
        }
        LOG.trace("Found {} suitable setter methods for setting {}", (Object)candidates.size(), (Object)name);
        for (Method method : candidates) {
            if (!method.getParameterTypes()[0].isInstance(value)) continue;
            LOG.trace("Method {} is the best candidate as it has parameter with same instance type", (Object)method);
            candidates.clear();
            candidates.add(method);
            return candidates;
        }
        return candidates;
    }

    protected static List<Method> findSetterMethodsOrderedByParameterType(Class<?> target, String propertyName, boolean allowBuilderPattern) {
        LinkedList<Method> answer = new LinkedList<Method>();
        LinkedList<Method> primitives = new LinkedList<Method>();
        Set<Method> setters = IntrospectionSupport.findSetterMethods(target, propertyName, allowBuilderPattern);
        for (Method setter : setters) {
            Class<?> parameterType = setter.getParameterTypes()[0];
            if (PRIMITIVE_CLASSES.contains(parameterType)) {
                primitives.add(setter);
                continue;
            }
            answer.add(setter);
        }
        answer.addAll(primitives);
        return answer;
    }

    static {
        EXCLUDED_METHODS.addAll(Arrays.asList(Object.class.getMethods()));
        EXCLUDED_METHODS.addAll(Arrays.asList(Proxy.class.getMethods()));
        PRIMITIVE_CLASSES = new HashSet<Class>();
        PRIMITIVE_CLASSES.add(String.class);
        PRIMITIVE_CLASSES.add(Character.class);
        PRIMITIVE_CLASSES.add(Boolean.class);
        PRIMITIVE_CLASSES.add(Byte.class);
        PRIMITIVE_CLASSES.add(Short.class);
        PRIMITIVE_CLASSES.add(Integer.class);
        PRIMITIVE_CLASSES.add(Long.class);
        PRIMITIVE_CLASSES.add(Float.class);
        PRIMITIVE_CLASSES.add(Double.class);
        PRIMITIVE_CLASSES.add(Character.TYPE);
        PRIMITIVE_CLASSES.add(Boolean.TYPE);
        PRIMITIVE_CLASSES.add(Byte.TYPE);
        PRIMITIVE_CLASSES.add(Short.TYPE);
        PRIMITIVE_CLASSES.add(Integer.TYPE);
        PRIMITIVE_CLASSES.add(Long.TYPE);
        PRIMITIVE_CLASSES.add(Float.TYPE);
        PRIMITIVE_CLASSES.add(Double.TYPE);
    }
}

