/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.jms.DefaultJmsKeyFormatStrategy;
import org.apache.camel.component.jms.DefaultQueueBrowseStrategy;
import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsHeaderFilterStrategy;
import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsQueueEndpoint;
import org.apache.camel.component.jms.JmsTemporaryQueueEndpoint;
import org.apache.camel.component.jms.JmsTemporaryTopicEndpoint;
import org.apache.camel.component.jms.MessageListenerContainerFactory;
import org.apache.camel.component.jms.PassThroughJmsKeyFormatStrategy;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.apache.camel.component.jms.ReplyToType;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.connection.JmsTransactionManager;
import org.springframework.jms.connection.UserCredentialsConnectionFactoryAdapter;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;

public class JmsComponent
extends DefaultComponent
implements ApplicationContextAware,
HeaderFilterStrategyAware {
    private static final String KEY_FORMAT_STRATEGY_PARAM = "jmsKeyFormatStrategy";
    private JmsConfiguration configuration;
    private ApplicationContext applicationContext;
    private QueueBrowseStrategy queueBrowseStrategy;
    private HeaderFilterStrategy headerFilterStrategy = new JmsHeaderFilterStrategy();
    private ExecutorService asyncStartStopExecutorService;
    private MessageListenerContainerFactory messageListenerContainerFactory;

    public JmsComponent() {
    }

    public JmsComponent(CamelContext context) {
        super(context);
    }

    public JmsComponent(JmsConfiguration configuration) {
        this.configuration = configuration;
    }

    public static JmsComponent jmsComponent() {
        return new JmsComponent();
    }

    public static JmsComponent jmsComponent(JmsConfiguration configuration) {
        return new JmsComponent(configuration);
    }

    public static JmsComponent jmsComponent(ConnectionFactory connectionFactory) {
        return JmsComponent.jmsComponent(new JmsConfiguration(connectionFactory));
    }

    public static JmsComponent jmsComponentClientAcknowledge(ConnectionFactory connectionFactory) {
        JmsConfiguration template = new JmsConfiguration(connectionFactory);
        template.setAcknowledgementMode(2);
        return JmsComponent.jmsComponent(template);
    }

    public static JmsComponent jmsComponentAutoAcknowledge(ConnectionFactory connectionFactory) {
        JmsConfiguration template = new JmsConfiguration(connectionFactory);
        template.setAcknowledgementMode(1);
        return JmsComponent.jmsComponent(template);
    }

    public static JmsComponent jmsComponentTransacted(ConnectionFactory connectionFactory) {
        JmsTransactionManager transactionManager = new JmsTransactionManager();
        transactionManager.setConnectionFactory(connectionFactory);
        return JmsComponent.jmsComponentTransacted(connectionFactory, (PlatformTransactionManager)transactionManager);
    }

    public static JmsComponent jmsComponentTransacted(ConnectionFactory connectionFactory, PlatformTransactionManager transactionManager) {
        JmsConfiguration template = new JmsConfiguration(connectionFactory);
        template.setTransactionManager(transactionManager);
        template.setTransacted(true);
        template.setTransactedInOut(true);
        return JmsComponent.jmsComponent(template);
    }

    public JmsConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.createConfiguration();
            if (this.applicationContext != null) {
                Map beansOfTypeDestinationResolver;
                Map beansOfTypeConnectionFactory = this.applicationContext.getBeansOfType(ConnectionFactory.class);
                if (!beansOfTypeConnectionFactory.isEmpty()) {
                    ConnectionFactory cf = (ConnectionFactory)beansOfTypeConnectionFactory.values().iterator().next();
                    this.configuration.setConnectionFactory(cf);
                }
                if (!(beansOfTypeDestinationResolver = this.applicationContext.getBeansOfType(DestinationResolver.class)).isEmpty()) {
                    DestinationResolver destinationResolver = (DestinationResolver)beansOfTypeDestinationResolver.values().iterator().next();
                    this.configuration.setDestinationResolver(destinationResolver);
                }
            }
        }
        return this.configuration;
    }

    public void setConfiguration(JmsConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setAcceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
        this.getConfiguration().setAcceptMessagesWhileStopping(acceptMessagesWhileStopping);
    }

    public void setAcknowledgementMode(int consumerAcknowledgementMode) {
        this.getConfiguration().setAcknowledgementMode(consumerAcknowledgementMode);
    }

    public void setEagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
        this.getConfiguration().setEagerLoadingOfProperties(eagerLoadingOfProperties);
    }

    public void setAcknowledgementModeName(String consumerAcknowledgementMode) {
        this.getConfiguration().setAcknowledgementModeName(consumerAcknowledgementMode);
    }

    public void setAutoStartup(boolean autoStartup) {
        this.getConfiguration().setAutoStartup(autoStartup);
    }

    public void setCacheLevel(int cacheLevel) {
        this.getConfiguration().setCacheLevel(cacheLevel);
    }

    public void setCacheLevelName(String cacheName) {
        this.getConfiguration().setCacheLevelName(cacheName);
    }

    public void setReplyToCacheLevelName(String cacheName) {
        this.getConfiguration().setReplyToCacheLevelName(cacheName);
    }

    public void setClientId(String consumerClientId) {
        this.getConfiguration().setClientId(consumerClientId);
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.getConfiguration().setConcurrentConsumers(concurrentConsumers);
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.getConfiguration().setConnectionFactory(connectionFactory);
    }

    public void setDeliveryPersistent(boolean deliveryPersistent) {
        this.getConfiguration().setDeliveryPersistent(deliveryPersistent);
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.getConfiguration().setDurableSubscriptionName(durableSubscriptionName);
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.getConfiguration().setExceptionListener(exceptionListener);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.getConfiguration().setErrorHandler(errorHandler);
    }

    public void setErrorHandlerLoggingLevel(LoggingLevel errorHandlerLoggingLevel) {
        this.getConfiguration().setErrorHandlerLoggingLevel(errorHandlerLoggingLevel);
    }

    public void setErrorHandlerLogStackTrace(boolean errorHandlerLogStackTrace) {
        this.getConfiguration().setErrorHandlerLogStackTrace(errorHandlerLogStackTrace);
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.getConfiguration().setExplicitQosEnabled(explicitQosEnabled);
    }

    public void setExposeListenerSession(boolean exposeListenerSession) {
        this.getConfiguration().setExposeListenerSession(exposeListenerSession);
    }

    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        this.getConfiguration().setIdleTaskExecutionLimit(idleTaskExecutionLimit);
    }

    public void setIdleConsumerLimit(int idleConsumerLimit) {
        this.getConfiguration().setIdleConsumerLimit(idleConsumerLimit);
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.getConfiguration().setMaxConcurrentConsumers(maxConcurrentConsumers);
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        this.getConfiguration().setMaxMessagesPerTask(maxMessagesPerTask);
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.getConfiguration().setMessageConverter(messageConverter);
    }

    public void setMapJmsMessage(boolean mapJmsMessage) {
        this.getConfiguration().setMapJmsMessage(mapJmsMessage);
    }

    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.getConfiguration().setMessageIdEnabled(messageIdEnabled);
    }

    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.getConfiguration().setMessageTimestampEnabled(messageTimestampEnabled);
    }

    public void setAlwaysCopyMessage(boolean alwaysCopyMessage) {
        this.getConfiguration().setAlwaysCopyMessage(alwaysCopyMessage);
    }

    public void setUseMessageIDAsCorrelationID(boolean useMessageIDAsCorrelationID) {
        this.getConfiguration().setUseMessageIDAsCorrelationID(useMessageIDAsCorrelationID);
    }

    public void setPriority(int priority) {
        this.getConfiguration().setPriority(priority);
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.getConfiguration().setPubSubNoLocal(pubSubNoLocal);
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.getConfiguration().setReceiveTimeout(receiveTimeout);
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.getConfiguration().setRecoveryInterval(recoveryInterval);
    }

    @Deprecated
    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.getConfiguration().setSubscriptionDurable(subscriptionDurable);
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.getConfiguration().setTaskExecutor(taskExecutor);
    }

    public void setTimeToLive(long timeToLive) {
        this.getConfiguration().setTimeToLive(timeToLive);
    }

    public void setTransacted(boolean consumerTransacted) {
        this.getConfiguration().setTransacted(consumerTransacted);
    }

    public void setLazyCreateTransactionManager(boolean lazyCreating) {
        this.getConfiguration().setLazyCreateTransactionManager(lazyCreating);
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.getConfiguration().setTransactionManager(transactionManager);
    }

    public void setTransactionName(String transactionName) {
        this.getConfiguration().setTransactionName(transactionName);
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.getConfiguration().setTransactionTimeout(transactionTimeout);
    }

    public void setTestConnectionOnStartup(boolean testConnectionOnStartup) {
        this.getConfiguration().setTestConnectionOnStartup(testConnectionOnStartup);
    }

    public void setAsyncStartListener(boolean asyncStartListener) {
        this.getConfiguration().setAsyncStartListener(asyncStartListener);
    }

    public void setAsyncStopListener(boolean asyncStopListener) {
        this.getConfiguration().setAsyncStopListener(asyncStopListener);
    }

    public void setForceSendOriginalMessage(boolean forceSendOriginalMessage) {
        this.getConfiguration().setForceSendOriginalMessage(forceSendOriginalMessage);
    }

    public void setRequestTimeout(long requestTimeout) {
        this.getConfiguration().setRequestTimeout(requestTimeout);
    }

    public void setRequestTimeoutCheckerInterval(long requestTimeoutCheckerInterval) {
        this.getConfiguration().setRequestTimeoutCheckerInterval(requestTimeoutCheckerInterval);
    }

    public void setTransferExchange(boolean transferExchange) {
        this.getConfiguration().setTransferExchange(transferExchange);
    }

    public void setTransferException(boolean transferException) {
        this.getConfiguration().setTransferException(transferException);
    }

    public void setJmsOperations(JmsOperations jmsOperations) {
        this.getConfiguration().setJmsOperations(jmsOperations);
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.getConfiguration().setDestinationResolver(destinationResolver);
    }

    public void setReplyToType(ReplyToType replyToType) {
        this.getConfiguration().setReplyToType(replyToType);
    }

    public void setPreserveMessageQos(boolean preserveMessageQos) {
        this.getConfiguration().setPreserveMessageQos(preserveMessageQos);
    }

    public void setAsyncConsumer(boolean asyncConsumer) {
        this.getConfiguration().setAsyncConsumer(asyncConsumer);
    }

    public void setAllowNullBody(boolean allowNullBody) {
        this.getConfiguration().setAllowNullBody(allowNullBody);
    }

    public void setIncludeSentJMSMessageID(boolean includeSentJMSMessageID) {
        this.getConfiguration().setIncludeSentJMSMessageID(includeSentJMSMessageID);
    }

    public void setDefaultTaskExecutorType(DefaultTaskExecutorType type) {
        this.getConfiguration().setDefaultTaskExecutorType(type);
    }

    public void setJmsKeyFormatStrategy(JmsKeyFormatStrategy jmsKeyFormatStrategy) {
        this.getConfiguration().setJmsKeyFormatStrategy(jmsKeyFormatStrategy);
    }

    public void setJmsKeyFormatStrategy(String jmsKeyFormatStrategyName) {
        JmsKeyFormatStrategy strategy = JmsComponent.resolveStandardJmsKeyFormatStrategy(jmsKeyFormatStrategyName);
        if (strategy == null) {
            throw new IllegalArgumentException("JmsKeyFormatStrategy with name " + jmsKeyFormatStrategyName + " is not a standard supported name");
        }
        this.getConfiguration().setJmsKeyFormatStrategy(strategy);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public QueueBrowseStrategy getQueueBrowseStrategy() {
        if (this.queueBrowseStrategy == null) {
            this.queueBrowseStrategy = new DefaultQueueBrowseStrategy();
        }
        return this.queueBrowseStrategy;
    }

    public void setQueueBrowseStrategy(QueueBrowseStrategy queueBrowseStrategy) {
        this.queueBrowseStrategy = queueBrowseStrategy;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    protected void doShutdown() throws Exception {
        if (this.asyncStartStopExecutorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.asyncStartStopExecutorService);
            this.asyncStartStopExecutorService = null;
        }
        super.doShutdown();
    }

    protected synchronized ExecutorService getAsyncStartStopExecutorService() {
        if (this.asyncStartStopExecutorService == null) {
            this.asyncStartStopExecutorService = this.getCamelContext().getExecutorServiceManager().newCachedThreadPool((Object)this, "AsyncStartStopListener");
        }
        return this.asyncStartStopExecutorService;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        JmsEndpoint endpoint;
        boolean pubSubDomain = false;
        boolean tempDestination = false;
        if (remaining.startsWith("queue:")) {
            pubSubDomain = false;
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("queue:".length()), (char)'/');
        } else if (remaining.startsWith("topic:")) {
            pubSubDomain = true;
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("topic:".length()), (char)'/');
        } else if (remaining.startsWith("temp:queue:")) {
            pubSubDomain = false;
            tempDestination = true;
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("temp:queue:".length()), (char)'/');
        } else if (remaining.startsWith("temp:topic:")) {
            pubSubDomain = true;
            tempDestination = true;
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("temp:topic:".length()), (char)'/');
        }
        String subject = this.convertPathToActualDestination(remaining, parameters);
        JmsConfiguration newConfiguration = this.getConfiguration().copy();
        if (pubSubDomain) {
            endpoint = tempDestination ? new JmsTemporaryTopicEndpoint(uri, this, subject, newConfiguration) : new JmsEndpoint(uri, this, subject, pubSubDomain, newConfiguration);
        } else {
            QueueBrowseStrategy strategy = this.getQueueBrowseStrategy();
            endpoint = tempDestination ? new JmsTemporaryQueueEndpoint(uri, this, subject, newConfiguration, strategy) : new JmsQueueEndpoint(uri, this, subject, newConfiguration, strategy);
        }
        ConnectionFactory cf = (ConnectionFactory)this.resolveAndRemoveReferenceParameter(parameters, "connectionFactory", ConnectionFactory.class);
        if (cf != null) {
            endpoint.getConfiguration().setConnectionFactory(cf);
        }
        String username = (String)this.getAndRemoveParameter(parameters, "username", String.class);
        String password = (String)this.getAndRemoveParameter(parameters, "password", String.class);
        if (username != null && password != null) {
            cf = endpoint.getConfiguration().getConnectionFactory();
            UserCredentialsConnectionFactoryAdapter ucfa = new UserCredentialsConnectionFactoryAdapter();
            ucfa.setTargetConnectionFactory(cf);
            ucfa.setPassword(password);
            ucfa.setUsername(username);
            endpoint.getConfiguration().setConnectionFactory((ConnectionFactory)ucfa);
        } else if (username != null || password != null) {
            throw new IllegalArgumentException("The JmsComponent's username or password is null");
        }
        String strategyVal = (String)this.getAndRemoveParameter(parameters, KEY_FORMAT_STRATEGY_PARAM, String.class);
        JmsKeyFormatStrategy strategy = JmsComponent.resolveStandardJmsKeyFormatStrategy(strategyVal);
        if (strategy != null) {
            endpoint.setJmsKeyFormatStrategy(strategy);
        } else {
            parameters.put(KEY_FORMAT_STRATEGY_PARAM, strategyVal);
            endpoint.setJmsKeyFormatStrategy((JmsKeyFormatStrategy)this.resolveAndRemoveReferenceParameter(parameters, KEY_FORMAT_STRATEGY_PARAM, JmsKeyFormatStrategy.class));
        }
        this.messageListenerContainerFactory = (MessageListenerContainerFactory)this.resolveAndRemoveReferenceParameter(parameters, "messageListenerContainerFactoryRef", MessageListenerContainerFactory.class);
        if (this.messageListenerContainerFactory != null) {
            endpoint.setMessageListenerContainerFactory(this.messageListenerContainerFactory);
        }
        this.setProperties(endpoint.getConfiguration(), parameters);
        endpoint.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        return endpoint;
    }

    private static JmsKeyFormatStrategy resolveStandardJmsKeyFormatStrategy(String name) {
        if ("default".equalsIgnoreCase(name)) {
            return new DefaultJmsKeyFormatStrategy();
        }
        if ("passthrough".equalsIgnoreCase(name)) {
            return new PassThroughJmsKeyFormatStrategy();
        }
        return null;
    }

    protected String convertPathToActualDestination(String path, Map<String, Object> parameters) {
        return path;
    }

    protected JmsConfiguration createConfiguration() {
        return new JmsConfiguration();
    }
}

