/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CamelContextTestRegistry.java 19913 2010-06-02 16:00:27Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.service.itests;

import java.io.InputStream;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.osgi.CompositeRegistry;
import org.ow2.jonas.camel.registry.xml.RegistryWrapper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * @author zeng-ls
 */
public class CamelContextTestRegistry {
    /**
     * The logger.
     */
    private Log logger = LogFactory.getLog(this.getClass());

    /**
     * The camel service. Injected by the container.
     */
    private CamelContext camelContext = null;

    /**
     * Start the route.
     */
    public void start() throws Throwable {
        try {
            this.logger.info("Camel context {0} started", this.camelContext.getName());
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("registry.xml");
            RegistryWrapper registrywrapper = new RegistryWrapper();
            /**
             * Creates the registry associate the context to it.
             */
            registrywrapper.createRegistryAndAssignToContext((DefaultCamelContext) this.camelContext);

            /**
             * Add entries to the registry.
             */
            registrywrapper.addToTheRegistry(in);
            /**
             * Check it.
             */
            this.checkit(registrywrapper);
            /**
             * The wrapper creates the registry + the caller adds it to the
             * camel context
             */

            registrywrapper = new RegistryWrapper();
            in = this.getClass().getClassLoader().getResourceAsStream("registry.xml");
            CompositeRegistry registry = registrywrapper.createRegistry(this.camelContext);
            ((DefaultCamelContext) this.camelContext).setRegistry(registry);
            registrywrapper.addToTheRegistry(in);
            this.checkit(registrywrapper);

            // Add the route in the camel context.
        } catch (Throwable t) {
            this.logger.error("Cannot start CamelContextTestRegistry", t);
            throw t;
        }
    }

    private void checkit(final RegistryWrapper registrywrapper) throws Exception {
        Endpoint endpoint = (Endpoint) this.camelContext.getRegistry().lookup("queue");
        if (!endpoint.getEndpointUri().equals("file://C:/Docume~1/My User")) {
            throw new Exception("Wrong value for logical name 'queue' in the regsitry."
                + "Expected: file://C:/Docume~1/My User. Current:" + endpoint.getEndpointUri());
        }
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("registry.xml");
        registrywrapper.removeFromTheRegistry(in);
        endpoint = (Endpoint) this.camelContext.getRegistry().lookup("queue");
        if (endpoint != null) {
            throw new Exception("The resgitry should be empty");
        }
    }

    /**
     * Stop the route.
     */
    public void stop() throws Exception {
        this.camelContext.stop();
    }

}
