/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DefaultTraceEventMessageToStringProcessor.java 19784 2010-04-28 17:05:13Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.component;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;

public class DefaultTraceEventMessageToStringProcessor implements Processor {

    public void process(final Exchange exchange) throws Exception {
        Exchange originalExchange = exchange.getProperty(Exchange.TRACE_EVENT_EXCHANGE, Exchange.class);
        exchange.getOut().setBody(MessageFormatter.formatMessage(originalExchange));
    }
}
