/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ICamelWrapper.java 19913 2010-06-02 16:00:27Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.wrapper;

import java.io.InputStream;
import java.util.List;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.ow2.jonas.camel.registry.xml.RegistryWrapper;

/**
 * @author Guillaume Renault
 */
public interface ICamelWrapper {
    /**
     * Get a producer template for the camel context.
     * 
     * @return a producer for the camel context.
     */
    ProducerTemplate getProducerTemplate();

    /**
     * Stop the camel context.
     * 
     * @throws Exception If stopping fails.
     */
    void stopContext() throws Exception;

    /**
     * @param builder the route to add.
     * @throws Exception If adding routes fails.
     */
    void addRoutes(final RouteBuilder builder) throws Exception;

    /**
     * @return the list of deployed routes on the camel context.
     */
    List<RouteDefinition> getRouteDefinitions();

    /**
     * Add values to the registy.
     * 
     * @param inputStream the input stream containing the entire xml file that
     *        defines the entries to add.
     * @throws Exception
     */
    void addToTheRegistry(final InputStream inputStream) throws Exception;

    /**
     * Remove values from the registy.
     * 
     * @param inputStream the input stream containing the entire xml file that
     *        defines the entries to remove.
     */
    void removeFromTheRegistry(final InputStream inputStream);

    /**
     * @return the registry wrapper.
     */
    RegistryWrapper getRegistryWrapper();

    /**
     * Add a component on the given camel context.
     * 
     * @param componentName the component name.
     * @param component the component.
     */
    void addComponent(final String componentName, final Component component);

    /**
     * @return the wrapped camel instance.
     */
    CamelContext getCamelContext();
}
