/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ProducerProcessorUsingBundleClassLoader.java 20652 2010-12-21 17:06:53Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.component;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;

/**
 * CAMEL producer with the bundle's ClassLoader.
 */
public class ProducerProcessorUsingBundleClassLoader implements Processor {

    private String destination;

    public ProducerProcessorUsingBundleClassLoader(final String destination) {
        this.destination = destination;
    }

    public void process(final Exchange exchange) throws Exception {
        final ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());

            Endpoint trace = exchange.getContext().getEndpoint(this.destination);
            Producer producer = trace.createProducer();
            Exchange exchangeCopy = exchange.copy();
            // We need to use pattern ExchangePattern.InOnly as some components
            // (for example, CXF) set the Exchange as ExchangePattern.InOut;
            // which might result in ExchangeTimedOutExceptions being thrown,
            // unwanted stack traces being logged or unneeded delays.
            exchangeCopy.setPattern(ExchangePattern.InOnly);

            producer.process(exchangeCopy);
        } finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
    }
}
