/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: LazySimpleRegistry.java 19962 2010-06-08 22:17:30Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.registry.xml;

import org.apache.camel.CamelContext;
import org.apache.camel.impl.SimpleRegistry;

/**
 * {@link SimpleRegistry} with lazy lookup.
 */
public class LazySimpleRegistry extends SimpleRegistry {

    private CamelContext context;

    public LazySimpleRegistry(final CamelContext context) {
        this.context = context;
    }

    @Override
    public Object lookup(String name) {
        Object object = get(name);
        if (object instanceof String) {
            return context.getEndpoint((String) object);
        } else {
            return object;
        }
    }

}
