/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: MockBundleContext.java 20427 2010-10-07 11:34:42Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.service.test;

import java.io.File;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Properties;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class MockBundleContext implements BundleContext {

    private final Properties properties = new Properties();

    public void setProperty(String name, String value) {
        if (value == null) {
            properties.remove(name);
        } else {
            properties.setProperty(name, value);
        }
    }

    public void addBundleListener(BundleListener arg0) {
    }

    public void addFrameworkListener(FrameworkListener arg0) {
    }

    public void addServiceListener(ServiceListener arg0) {
    }

    public void addServiceListener(ServiceListener arg0, String arg1) throws InvalidSyntaxException {
    }

    public Filter createFilter(String arg0) throws InvalidSyntaxException {
        return null;
    }

    public ServiceReference[] getAllServiceReferences(String arg0, String arg1) throws InvalidSyntaxException {
        return null;
    }

    public Bundle getBundle() {
        return new MockBundle(this, 0, "mock");
    }

    public Bundle getBundle(long arg0) {
        return new MockBundle(this, 0, "mock");
    }

    public Bundle[] getBundles() {
        return new Bundle[0];
    }

    public File getDataFile(String arg0) {
        return null;
    }

    public String getProperty(String name) {
        return properties.getProperty(name);
    }

    public Object getService(ServiceReference arg0) {
        return null;
    }

    public ServiceReference getServiceReference(String arg0) {
        return null;
    }

    public ServiceReference[] getServiceReferences(String arg0, String arg1) throws InvalidSyntaxException {
        return null;
    }

    public Bundle installBundle(String arg0) throws BundleException {
        return null;
    }

    public Bundle installBundle(String arg0, InputStream arg1) throws BundleException {
        return null;
    }

    public ServiceRegistration registerService(String[] arg0, Object arg1, Dictionary arg2) {
        return null;
    }

    public ServiceRegistration registerService(String arg0, Object arg1, Dictionary arg2) {
        return null;
    }

    public void removeBundleListener(BundleListener arg0) {
    }

    public void removeFrameworkListener(FrameworkListener arg0) {
    }

    public void removeServiceListener(ServiceListener arg0) {
    }

    public boolean ungetService(ServiceReference arg0) {
        return false;
    }
}
