/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JmsTest.java 18808 2009-09-29 16:08:11Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.example.jms.test;

import java.io.File;
import java.util.Hashtable;
import java.util.UUID;

import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JmsTest {

    /**
     * Initial Context Factory.
     */
    private static final String INITIAL_CONTEXT_FACTORY = "org.ow2.carol.jndi.spi.MultiOrbInitialContextFactory";

    private int port;

    private int timeout;

    private File jonasLogs;

    @Before
    public void setUp() throws Exception {
        String webcontainerPort = System.getProperty("carol.port");
        Assert.assertNotNull("carol.port is not set!", webcontainerPort);
        this.port = Integer.parseInt(webcontainerPort);

        String jonasBase = System.getProperty("jonas.base");
        Assert.assertNotNull("jonas.base is not set!", jonasBase);
        File jonasBaseFile = new File(jonasBase);
        Assert.assertTrue(jonasBaseFile + " is not a directory", jonasBaseFile.isDirectory());
        this.jonasLogs = new File(jonasBaseFile, "logs");
        Assert.assertTrue(this.jonasLogs + " is not a directory", this.jonasLogs.isDirectory());

        String timeout = System.getProperty("timeout");
        Assert.assertNotNull("timeout is not set!", webcontainerPort);
        this.timeout = Integer.parseInt(timeout);
    }

    @Test
    public void testJMSReceiverRoute() throws Exception {
        String message = UUID.randomUUID().toString();
        File logFile = new File(this.jonasLogs, message);

        Assert.assertFalse(logFile + " already exists", logFile.isFile());

        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put(Context.INITIAL_CONTEXT_FACTORY, JmsTest.INITIAL_CONTEXT_FACTORY);
        env.put(Context.PROVIDER_URL, "rmi://localhost:" + this.port);
        Context context = new InitialContext(env);
        QueueConnectionFactory connectionFactory = (QueueConnectionFactory) context.lookup("JQCF");
        QueueConnection queueConnection = connectionFactory.createQueueConnection();
        QueueSession queueSession = queueConnection.createQueueSession(false, Session.AUTO_ACKNOWLEDGE);
        Queue queue = (Queue) context.lookup("sampleQueue");
        QueueSender jmsSender = queueSession.createSender(queue);
        TextMessage jmsMessage = queueSession.createTextMessage(message);
        jmsSender.send(jmsMessage);

        final long stopTime = System.currentTimeMillis() + this.timeout * 1000;
        while (System.currentTimeMillis() < stopTime) {
            if (logFile.isFile()) {
                return;
            }
        }

        Assert.fail(logFile + " does not exist");
    }
}
