/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: OsgiCxfServletTransportFactory.java 22122 2012-02-18 19:39:24Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.cxf.servlet;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import org.apache.cxf.Bus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.http.HTTPTransportFactory;

/**
 * @author Guillaume Porcher
 */
public class OsgiCxfServletTransportFactory extends HTTPTransportFactory {

    private final String context;

    public OsgiCxfServletTransportFactory(final Bus bus, final String context) {
        super(bus);
        this.context = context;
    }

    /**
     * Publish destination with an address relative to the servlet context.
     */
    @Override
    public Destination getDestination(final EndpointInfo endpointInfo) throws IOException {
        endpointInfo.setAddress(this.removeContextFromPath(endpointInfo.getAddress()));
        return super.getDestination(endpointInfo);
    }

    /**
     * Remove servlet context (e.g. http://localhost:port/context/) from
     * request.
     * 
     * @param path
     * @return
     */
    private String removeContextFromPath(final String path) {
        try {
            final URL url = new URL(path);
            final String urlPath = url.getPath();
            if (urlPath.startsWith(this.context)) {
                return urlPath.substring(this.context.length());
            }
        } catch (final MalformedURLException e) {
            return path;
        }
        return path;
    }
}