/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2009-2012 Bull S.A.S. * Copyright (C) 2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: OsgiCXFServletDeployer.java 22122 2012-02-18 19:39:24Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.cxf.servlet;

import java.util.Dictionary;
import java.util.Hashtable;

import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.http.HttpDestinationFactory;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.apache.cxf.transport.servlet.ServletDestinationFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * @author Guillaume Porcher
 */
public class OsgiCXFServletDeployer {

    /**
     * The logger.
     */
    private Log logger = LogFactory.getLog(this.getClass());

    private CXFNonSpringServlet cxf;

    // Injected by iPOJO
    private HttpService m_httpService;

    private String m_servletPath;

    private String m_busName;

    private final BundleContext bundleContext;

    private ServiceRegistration serviceRegistration;

    public OsgiCXFServletDeployer(final BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void start() throws Throwable {
        try {
            // Create CXF Servlet
            this.cxf = new OsgiHttpServiceCXFServlet(this.m_servletPath);

            // Register servlet
            final HttpContext context = this.m_httpService.createDefaultHttpContext();
            this.m_httpService.registerServlet(this.m_servletPath, this.cxf, null, context);

            // Add bus to OSGi context
            final Bus bus = this.cxf.getBus();
            final Dictionary<String, String> properties = new Hashtable<String, String>();
            properties.put("name", this.m_busName);
            this.serviceRegistration = this.bundleContext.registerService(Bus.class.getName(), bus, properties);

            this.logger.info("OsgiCXFServletDeployer started on path {0}", this.m_servletPath);
        } catch (Throwable t) {
            this.logger.error("Cannot start OsgiCXFServletDeployer", t);
            throw t;
        }
    }

    public void stop() throws Throwable {
        if (this.m_httpService != null) {
            try {
                this.m_httpService.unregister(this.m_servletPath);
            } catch (IllegalArgumentException ignored) {
                // m_servletPath not registered, ignore
            }
        }
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }
}
